/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.expression.ExpressionEvaluatorObjects;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessingContext
implements IProcessingContext {
    protected static final String EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME = "%%{SELECTION_TARGET}%%";
    private final IContext context;
    private final Object evaluationRoot;
    private final Object selectionEvaluationRoot;
    private final HashMap<String, Object> localVariables;
    private boolean computedBaseContextVariables = false;
    private Map<String, Object> expressionObjects = null;

    protected AbstractProcessingContext(IContext context) {
        this(context, null, null, false);
    }

    protected AbstractProcessingContext(IContext context, Map<String, Object> localVariables) {
        this(context, localVariables, null, false);
    }

    protected AbstractProcessingContext(IContext context, Map<String, Object> localVariables, Object selectionTarget, boolean selectionTargetSet) {
        Validate.notNull((Object)context, (String)"Context cannot be null");
        this.context = context;
        HashMap hashMap = localVariables != null ? new HashMap(localVariables) : (this.localVariables = selectionTargetSet ? new HashMap(2, 1.0f) : null);
        if (selectionTargetSet) {
            this.localVariables.put(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME, selectionTarget);
        }
        this.evaluationRoot = this.createEvaluationRoot();
        this.selectionEvaluationRoot = this.createSelectedEvaluationRoot();
    }

    private Object createEvaluationRoot() {
        VariablesMap<String, Object> contextVariables = this.context.getVariables();
        VariablesMap<String, Object> newEvaluationRoot = new VariablesMap<String, Object>(contextVariables);
        if (this.localVariables != null) {
            newEvaluationRoot.putAll(this.localVariables);
        }
        return newEvaluationRoot;
    }

    private Object createSelectedEvaluationRoot() {
        if (this.hasSelectionTarget()) {
            return this.getSelectionTarget();
        }
        return this.evaluationRoot;
    }

    protected Map<String, Object> computeExpressionObjects() {
        return ExpressionEvaluatorObjects.computeEvaluationObjects((IProcessingContext)this);
    }

    @Override
    public Map<String, Object> getExpressionObjects() {
        if (!this.computedBaseContextVariables) {
            this.computedBaseContextVariables = true;
            this.expressionObjects = this.computeExpressionObjects();
        }
        return this.expressionObjects;
    }

    @Override
    public IContext getContext() {
        return this.context;
    }

    @Override
    public Object getExpressionEvaluationRoot() {
        return this.evaluationRoot;
    }

    @Override
    public Object getExpressionSelectionEvaluationRoot() {
        return this.selectionEvaluationRoot;
    }

    @Override
    public boolean hasSelectionTarget() {
        return this.hasLocalVariable(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME) || this.getContext().getVariables().containsKey(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME);
    }

    @Override
    public Object getSelectionTarget() {
        if (this.hasLocalVariable(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME)) {
            return this.getLocalVariable(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME);
        }
        if (this.getContext().getVariables().containsKey(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME)) {
            return this.getContext().getVariables().get(EVAL_SELECTION_TARGET_LOCAL_VARIABLE_NAME);
        }
        return null;
    }

    @Override
    public boolean hasLocalVariables() {
        return this.localVariables != null && this.localVariables.size() > 0;
    }

    @Override
    public boolean hasLocalVariable(String variableName) {
        return this.localVariables != null && this.localVariables.containsKey(variableName);
    }

    @Override
    public Object getLocalVariable(String variableName) {
        if (this.localVariables == null) {
            return null;
        }
        return this.localVariables.get(variableName);
    }

    @Override
    public Map<String, Object> getLocalVariables() {
        if (this.localVariables != null) {
            return Collections.unmodifiableMap(this.localVariables);
        }
        return null;
    }

    protected Map<String, Object> mergeNewLocalVariables(Map<String, Object> newVariables) {
        if (newVariables == null || newVariables.isEmpty()) {
            return this.localVariables;
        }
        int localVariablesSize = this.localVariables != null ? this.localVariables.size() : 0;
        HashMap<String, Object> cloneLocalVariables = new HashMap<String, Object>(localVariablesSize + newVariables.size() + 1, 1.0f);
        if (this.localVariables != null) {
            cloneLocalVariables.putAll(this.localVariables);
        }
        cloneLocalVariables.putAll(newVariables);
        return cloneLocalVariables;
    }
}

