/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.zukunftswerk;

import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Cookies;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.event.PreSendTopic;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.IdList;
import systems.dmx.deepl.DeepLService;
import systems.dmx.deepl.Translation;
import systems.dmx.timestamps.TimestampsService;
import systems.dmx.workspaces.WorkspacesService;
import systems.dmx.zukunftswerk.Messenger;
import systems.dmx.zukunftswerk.ZukunftswerkService;

@Path(value="/zukunftswerk")
@Produces(value={"application/json"})
public class ZukunftswerkPlugin
extends PluginActivator
implements ZukunftswerkService,
PreSendTopic {
    @Inject
    private DeepLService deepls;
    @Inject
    private TimestampsService ts;
    @Inject
    private WorkspacesService ws;
    @Inject
    private AccessControlService acs;
    private Messenger me;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void init() {
        this.me = new Messenger(this.dmx.getWebSocketService());
    }

    public void preSendTopic(Topic topic) {
        if (topic.getTypeUri().equals("zukunftswerk.comment")) {
            this.acs.enrichWithUserInfo((DMXObject)topic);
        }
    }

    @Override
    @GET
    @Path(value="/discussion")
    public List<Topic> getDiscussion() {
        return DMXUtils.loadChildTopics((List)this.ws.getAssignedTopics(this.workspaceId(), "zukunftswerk.comment"));
    }

    @Override
    @POST
    @Path(value="/note")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createNote(String note) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("zukunftswerk.note", note));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating note failed, note=\"" + note + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/label")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createLabel(String label) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("zukunftswerk.label", label));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating label failed, label=\"" + label + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/comment")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createComment(String comment, @QueryParam(value="refTopicId") long refTopicId, @QueryParam(value="fileTopicIds") IdList fileTopicIds) {
        try {
            Object refTypeUri;
            TopicModel commentModel = this.createBilingualTopicModel("zukunftswerk.comment", comment);
            if (refTopicId != 0L) {
                refTypeUri = this.dmx.getTopic(refTopicId).getTypeUri();
                commentModel.getChildTopics().setRef((String)refTypeUri, refTopicId);
            }
            if (fileTopicIds != null) {
                refTypeUri = fileTopicIds.iterator();
                while (refTypeUri.hasNext()) {
                    long fileTopicId = (Long)refTypeUri.next();
                    commentModel.getChildTopics().addRef("dmx.files.file#zukunftswerk.attachment", fileTopicId);
                }
            }
            Topic commentTopic = this.dmx.createTopic(commentModel);
            this.acs.enrichWithUserInfo((DMXObject)commentTopic);
            this.ts.enrichWithTimestamps((DMXObject)commentTopic);
            this.me.createComment(this.workspaceId(), commentTopic);
            return commentTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating comment failed, refTopicId=" + refTopicId + ", fileTopicIds=" + fileTopicIds, e);
        }
    }

    private TopicModel createBilingualTopicModel(String topicTypeUri, String text) {
        String targetLang;
        Translation translation = (Translation)this.deepls.translate(text, "en").get(0);
        String origLang = translation.detectedSourceLang.toLowerCase();
        this.logger.info("origLang=\"" + origLang + "\"");
        if (origLang.equals("de")) {
            targetLang = "fr";
        } else if (origLang.equals("fr")) {
            targetLang = "de";
        } else {
            throw new RuntimeException("Unsupported original language: \"" + origLang + "\" (detected)");
        }
        String translatedComment = ((Translation)this.deepls.translate((String)text, (String)targetLang).get((int)0)).text;
        return this.mf.newTopicModel(topicTypeUri, this.mf.newChildTopicsModel().set(topicTypeUri + "." + origLang, (Object)text).set(topicTypeUri + "." + targetLang, (Object)translatedComment).set("zukunftswerk.language#zukunftswerk.original_language", (Object)origLang));
    }

    private long workspaceId() {
        return Cookies.get().getLong("dmx_workspace_id");
    }
}

