/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.zukunftswerk;

import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Transactional;
import systems.dmx.zukunftswerk.ZukunftswerkService;

@Path(value="/zukunftswerk")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ZukunftswerkPlugin
extends PluginActivator
implements ZukunftswerkService {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @POST
    @Path(value="/comment/{targetTopicId}")
    @Transactional
    public void addComment(TopicModel comment, @PathParam(value="targetTopicId") long targetTopicId) {
        try {
            comment.setTypeUri("zukunftswerk.comment");
            Topic commentTopic = this.dmx.createTopic(comment);
            this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.composition", (PlayerModel)this.mf.newTopicPlayerModel(targetTopicId, "dmx.core.parent"), (PlayerModel)this.mf.newTopicPlayerModel(commentTopic.getId(), "dmx.core.child")));
        }
        catch (Exception e) {
            throw new RuntimeException("Adding comment to topic " + targetTopicId + " failed, comment=" + comment, e);
        }
    }
}

