/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.zukunftswerk;

import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.deepl.DeepLService;
import systems.dmx.deepl.Translation;
import systems.dmx.zukunftswerk.ZukunftswerkService;

@Path(value="/zukunftswerk")
@Produces(value={"application/json"})
public class ZukunftswerkPlugin
extends PluginActivator
implements ZukunftswerkService {
    @Inject
    private DeepLService deepls;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/discussion/{targetTopicId}")
    public List<RelatedTopic> getDiscussion(@PathParam(value="targetTopicId") long targetTopicId) {
        return DMXUtils.loadChildTopics((List)this.dmx.getTopic(targetTopicId).getRelatedTopics("dmx.core.composition", "dmx.core.parent", "dmx.core.child", "zukunftswerk.comment"));
    }

    @Override
    @POST
    @Path(value="/comment/{targetTopicId}")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic addComment(String comment, @PathParam(value="targetTopicId") long targetTopicId) {
        try {
            String targetLang;
            Translation translation = (Translation)this.deepls.translate(comment, "EN").get(0);
            String origLang = translation.detectedSourceLang.toLowerCase();
            this.logger.info("origLang=\"" + origLang + "\"");
            if (origLang.equals("de")) {
                targetLang = "fr";
            } else if (origLang.equals("fr")) {
                targetLang = "de";
            } else {
                throw new RuntimeException("Unsupported original language: \"" + origLang + "\" (detected)");
            }
            String translatedComment = ((Translation)this.deepls.translate((String)comment, (String)targetLang).get((int)0)).text;
            Topic commentTopic = this.dmx.createTopic(this.mf.newTopicModel("zukunftswerk.comment", this.mf.newChildTopicsModel().set("zukunftswerk.comment." + origLang, (Object)comment).set("zukunftswerk.comment." + targetLang, (Object)translatedComment).set("zukunftswerk.language#zukunftswerk.original_language", (Object)origLang)));
            this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.composition", (PlayerModel)this.mf.newTopicPlayerModel(targetTopicId, "dmx.core.parent"), (PlayerModel)this.mf.newTopicPlayerModel(commentTopic.getId(), "dmx.core.child")));
            return commentTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Adding comment to topic " + targetTopicId + " failed, comment=" + comment, e);
        }
    }
}

