/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.zukunftswerk;

import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.deepl.DeepLService;
import systems.dmx.deepl.Translation;
import systems.dmx.zukunftswerk.ZukunftswerkService;

@Path(value="/zukunftswerk")
@Produces(value={"application/json"})
public class ZukunftswerkPlugin
extends PluginActivator
implements ZukunftswerkService {
    @Inject
    private DeepLService deepls;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/discussion/{workspaceId}")
    public List<RelatedTopic> getDiscussion(@PathParam(value="workspaceId") long workspaceId) {
        return DMXUtils.loadChildTopics((List)this.dmx.getTopic(workspaceId).getRelatedTopics("dmx.core.composition", "dmx.core.parent", "dmx.core.child", "zukunftswerk.comment"));
    }

    @Override
    @POST
    @Path(value="/note")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createNote(String note) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("zukunftswerk.note", note));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating note failed, text=" + note, e);
        }
    }

    @Override
    @POST
    @Path(value="/comment/{workspaceId}")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createComment(String comment, @PathParam(value="workspaceId") long workspaceId, @QueryParam(value="refTopicId") long refTopicId) {
        try {
            TopicModel commentModel = this.createBilingualTopicModel("zukunftswerk.comment", comment);
            if (refTopicId != 0L) {
                String refTypeUri = this.dmx.getTopic(refTopicId).getTypeUri();
                commentModel.getChildTopics().setRef(refTypeUri, refTopicId);
            }
            Topic commentTopic = this.dmx.createTopic(commentModel);
            this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.composition", (PlayerModel)this.mf.newTopicPlayerModel(workspaceId, "dmx.core.parent"), (PlayerModel)this.mf.newTopicPlayerModel(commentTopic.getId(), "dmx.core.child")));
            return commentTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Adding comment to workspace " + workspaceId + " failed, comment=" + comment, e);
        }
    }

    private TopicModel createBilingualTopicModel(String topicTypeUri, String text) {
        String targetLang;
        Translation translation = (Translation)this.deepls.translate(text, "en").get(0);
        String origLang = translation.detectedSourceLang.toLowerCase();
        this.logger.info("origLang=\"" + origLang + "\"");
        if (origLang.equals("de")) {
            targetLang = "fr";
        } else if (origLang.equals("fr")) {
            targetLang = "de";
        } else {
            throw new RuntimeException("Unsupported original language: \"" + origLang + "\" (detected)");
        }
        String translatedComment = ((Translation)this.deepls.translate((String)text, (String)targetLang).get((int)0)).text;
        return this.mf.newTopicModel(topicTypeUri, this.mf.newChildTopicsModel().set(topicTypeUri + "." + origLang, (Object)text).set(topicTypeUri + "." + targetLang, (Object)translatedComment).set("zukunftswerk.language#zukunftswerk.original_language", (Object)origLang));
    }
}

