/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.zukunftswerk;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Cookies;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.service.event.PreSendTopic;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.IdList;
import systems.dmx.deepl.DeepLService;
import systems.dmx.deepl.Translation;
import systems.dmx.timestamps.TimestampsService;
import systems.dmx.workspaces.WorkspacesService;
import systems.dmx.zukunftswerk.Messenger;
import systems.dmx.zukunftswerk.ZukunftswerkService;

@Path(value="/zukunftswerk")
@Produces(value={"application/json"})
public class ZukunftswerkPlugin
extends PluginActivator
implements ZukunftswerkService,
PreSendTopic {
    @Inject
    private DeepLService deepls;
    @Inject
    private TimestampsService ts;
    @Inject
    private WorkspacesService ws;
    @Inject
    private AccessControlService acs;
    private Messenger me;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void init() {
        this.me = new Messenger(this.dmx.getWebSocketService());
    }

    public void preSendTopic(Topic topic) {
        if (topic.getTypeUri().equals("zukunftswerk.comment")) {
            this.acs.enrichWithUserInfo((DMXObject)topic);
            RelatedTopic refComment = topic.getChildTopics().getTopicOrNull("zukunftswerk.comment");
            if (refComment != null) {
                this.acs.enrichWithUserInfo((DMXObject)refComment);
            }
        }
    }

    @Override
    @GET
    @Path(value="/discussion")
    public List<Topic> getDiscussion() {
        return DMXUtils.loadChildTopics((List)this.ws.getAssignedTopics(this.workspaceId(), "zukunftswerk.comment"));
    }

    @Override
    @POST
    @Path(value="/note")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createNote(String note) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("zukunftswerk.note", note));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating note failed, note=\"" + note + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/label")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createLabel(String label) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("zukunftswerk.label", label));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating label failed, label=\"" + label + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/comment")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createComment(String comment, @QueryParam(value="refTopicIds") IdList refTopicIds, @QueryParam(value="fileTopicIds") IdList fileTopicIds) {
        try {
            Iterator iterator;
            TopicModel commentModel = this.createBilingualTopicModel("zukunftswerk.comment", comment);
            if (refTopicIds != null) {
                iterator = refTopicIds.iterator();
                while (iterator.hasNext()) {
                    long refTopicId = (Long)iterator.next();
                    String refTypeUri = this.dmx.getTopic(refTopicId).getTypeUri();
                    commentModel.getChildTopics().setRef(refTypeUri, refTopicId);
                }
            }
            if (fileTopicIds != null) {
                iterator = fileTopicIds.iterator();
                while (iterator.hasNext()) {
                    long fileTopicId = (Long)iterator.next();
                    commentModel.getChildTopics().addRef("dmx.files.file#zukunftswerk.attachment", fileTopicId);
                }
            }
            Topic commentTopic = this.dmx.createTopic(commentModel);
            this.acs.enrichWithUserInfo((DMXObject)commentTopic);
            this.ts.enrichWithTimestamps((DMXObject)commentTopic);
            this.me.addComment(this.workspaceId(), commentTopic);
            return commentTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating comment failed, refTopicIds=" + refTopicIds + ", fileTopicIds=" + fileTopicIds, e);
        }
    }

    @Override
    @GET
    @Path(value="/admin/workspaces")
    public List<RelatedTopic> getZWWorkspaces() {
        try {
            return DMXUtils.loadChildTopics((List)this.dmx.getTopicByUri("systems.dmx.zukunftswerk").getRelatedTopics("zukunftswerk.shared_workspace", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace"));
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving the ZW workspaces failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/admin/users")
    public List<Topic> getUsers() {
        try {
            return this.dmx.getTopicsByType("dmx.accesscontrol.username");
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving the ZW users failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/admin/workspace")
    @Transactional
    public Topic createZWWorkspace(@QueryParam(value="nameDe") String nameDe, @QueryParam(value="nameFr") String nameFr) {
        try {
            Topic workspace = this.ws.createWorkspace(nameDe, null, SharingMode.PUBLIC);
            workspace.update(this.mf.newChildTopicsModel().set("dmx.workspaces.workspace_name#zukunftswerk.de", (Object)nameDe).set("dmx.workspaces.workspace_name#zukunftswerk.fr", (Object)nameFr));
            this.dmx.createAssoc(this.mf.newAssocModel("zukunftswerk.shared_workspace", (PlayerModel)this.mf.newTopicPlayerModel("systems.dmx.zukunftswerk", "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(workspace.getId(), "dmx.core.default")));
            return workspace;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating a ZW workspace failed", e);
        }
    }

    private TopicModel createBilingualTopicModel(String topicTypeUri, String text) {
        String targetLang;
        Translation translation = (Translation)this.deepls.translate(text, "en").get(0);
        String origLang = translation.detectedSourceLang.toLowerCase();
        this.logger.info("origLang=\"" + origLang + "\"");
        if (origLang.equals("de")) {
            targetLang = "fr";
        } else if (origLang.equals("fr")) {
            targetLang = "de";
        } else {
            throw new RuntimeException("Unsupported original language: \"" + origLang + "\" (detected)");
        }
        String translatedComment = ((Translation)this.deepls.translate((String)text, (String)targetLang).get((int)0)).text;
        return this.mf.newTopicModel(topicTypeUri, this.mf.newChildTopicsModel().set(topicTypeUri + "." + origLang, (Object)text).set(topicTypeUri + "." + targetLang, (Object)translatedComment).set("zukunftswerk.language#zukunftswerk.original_language", (Object)origLang));
    }

    private long workspaceId() {
        return Cookies.get().getLong("dmx_workspace_id");
    }
}

