/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.zukunftswerk;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.ChangeReport;
import systems.dmx.core.service.Cookies;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.service.event.PostCreateAssoc;
import systems.dmx.core.service.event.PostUpdateTopic;
import systems.dmx.core.service.event.PreDeleteAssoc;
import systems.dmx.core.service.event.PreSendTopic;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.IdList;
import systems.dmx.deepl.DeepLService;
import systems.dmx.deepl.Translation;
import systems.dmx.facets.FacetsService;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.signup.SignupService;
import systems.dmx.timestamps.TimestampsService;
import systems.dmx.topicmaps.TopicmapCustomizer;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.workspaces.WorkspacesService;
import systems.dmx.zukunftswerk.Messenger;
import systems.dmx.zukunftswerk.ZukunftswerkService;

@Path(value="/zukunftswerk")
@Produces(value={"application/json"})
public class ZukunftswerkPlugin
extends PluginActivator
implements ZukunftswerkService,
TopicmapCustomizer,
PostCreateAssoc,
PostUpdateTopic,
PreDeleteAssoc,
PreSendTopic {
    @Inject
    private DeepLService deepls;
    @Inject
    private TimestampsService tss;
    @Inject
    private TopicmapsService tms;
    @Inject
    private WorkspacesService ws;
    @Inject
    private AccessControlService acs;
    @Inject
    private FacetsService facets;
    @Inject
    private SignupService signup;
    @Inject
    private SendmailService sendmail;
    private Topic zwPluginTopic;
    private Topic teamWorkspace;
    private Messenger me;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void init() {
        this.zwPluginTopic = this.dmx.getTopicByUri("systems.dmx.zukunftswerk");
        this.teamWorkspace = this.dmx.getTopicByUri("zukunftswerk.team");
        this.me = new Messenger(this.dmx.getWebSocketService());
        this.tms.registerTopicmapCustomizer((TopicmapCustomizer)this);
    }

    public void shutdown() {
        this.tms.unregisterTopicmapCustomizer((TopicmapCustomizer)this);
    }

    public void postCreateAssoc(Assoc assoc) {
        this.processTeamMembership(assoc, username -> {
            this.logger.info("### Inviting user \"" + username + "\" to \"System\" workspace");
            this.acs.createMembership(username, this.dmx.getPrivilegedAccess().getSystemWorkspaceId());
            List<RelatedTopic> workspaces = this.getAllZWWorkspaces();
            this.logger.info("### Inviting user \"" + username + "\" to " + workspaces.size() + " ZW workspaces");
            this.acs.bulkUpdateMemberships(username, new IdList(workspaces), null);
        });
    }

    public void preDeleteAssoc(Assoc assoc) {
        this.processTeamMembership(assoc, username -> {
            this.logger.info("### Removing \"System\" membership from user \"" + username + "\"");
            this.acs.getMembership(username, this.dmx.getPrivilegedAccess().getSystemWorkspaceId()).delete();
        });
    }

    public void postUpdateTopic(Topic topic, ChangeReport report, TopicModel updateModel) {
        List changes;
        String origLang;
        if (topic.getTypeUri().equals("zukunftswerk.comment") && (origLang = topic.getChildTopics().getString("zukunftswerk.language#zukunftswerk.original_language", null)) != null && (changes = report.getChanges("zukunftswerk.comment." + this.targetLang(origLang))) != null) {
            topic.update(this.mf.newChildTopicsModel().set("zukunftswerk.translation_edited", (Object)true));
        }
    }

    public void preSendTopic(Topic topic) {
        RelatedTopic editor;
        Assoc assoc;
        String username;
        String displayName;
        if (topic.getTypeUri().equals("zukunftswerk.comment")) {
            this.acs.enrichWithUserInfo((DMXObject)topic);
            RelatedTopic refComment = topic.getChildTopics().getTopicOrNull("zukunftswerk.comment");
            if (refComment != null) {
                this.acs.enrichWithUserInfo((DMXObject)refComment);
            }
        } else if (topic.getTypeUri().equals("dmx.accesscontrol.username") && (displayName = this.signup.getDisplayName(username = topic.getSimpleValue().toString())) != null) {
            topic.getChildTopics().getModel().set("zukunftswerk.display_name", (Object)displayName);
        }
        if (topic instanceof RelatedTopic && (assoc = ((RelatedTopic)topic).getRelatingAssoc()).getTypeUri().equals("dmx.accesscontrol.membership") && (editor = this.facets.getFacet((DMXObject)assoc, "zukunftswerk.editor_facet")) != null) {
            assoc.getChildTopics().getModel().set("zukunftswerk.editor", editor.getModel());
        }
    }

    public void customizeTopic(RelatedTopic topic, ViewProps viewProps) {
        Assoc assoc = topic.getRelatingAssoc();
        if (topic.getTypeUri().equals("zukunftswerk.arrow")) {
            viewProps.set("zukunftswerk.x1", assoc.getProperty("zukunftswerk.x1")).set("zukunftswerk.y1", assoc.getProperty("zukunftswerk.y1")).set("zukunftswerk.x2", assoc.getProperty("zukunftswerk.x2")).set("zukunftswerk.y2", assoc.getProperty("zukunftswerk.y2"));
        } else if (topic.getTypeUri().equals("zukunftswerk.note") && assoc.hasProperty("zukunftswerk.color")) {
            viewProps.set("zukunftswerk.color", assoc.getProperty("zukunftswerk.color"));
        }
    }

    @Override
    @GET
    @Path(value="/workspaces")
    public List<RelatedTopic> getZWWorkspaces() {
        try {
            Topic username = this.acs.getUsernameTopic();
            if (username != null) {
                return this.getZWWorkspaces(username);
            }
            return new ArrayList<RelatedTopic>();
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving the user's ZW workspaces failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/discussion")
    public List<Topic> getDiscussion() {
        try {
            return DMXUtils.loadChildTopics((List)this.ws.getAssignedTopics(this.workspaceId(), "zukunftswerk.comment"));
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving the discussion for workspace " + this.workspaceId() + " failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/note")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createNote(String note) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("zukunftswerk.note", note));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating note failed, note=\"" + note + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/label")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createLabel(String label) {
        try {
            return this.dmx.createTopic(this.createBilingualTopicModel("zukunftswerk.label", label));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating label failed, label=\"" + label + "\"", e);
        }
    }

    @Override
    @POST
    @Path(value="/comment")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createComment(String comment, @QueryParam(value="refTopicIds") IdList refTopicIds, @QueryParam(value="fileTopicIds") IdList fileTopicIds) {
        try {
            return this._createComment(this.createBilingualTopicModel("zukunftswerk.comment", comment), refTopicIds, fileTopicIds);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating comment failed, comment=\"" + comment + "\", refTopicIds=" + refTopicIds + ", fileTopicIds=" + fileTopicIds, e);
        }
    }

    @Override
    @POST
    @Path(value="/comment/monolingual")
    @Consumes(value={"text/plain"})
    @Transactional
    public Topic createMonolingualComment(String comment, @QueryParam(value="refTopicIds") IdList refTopicIds, @QueryParam(value="fileTopicIds") IdList fileTopicIds) {
        try {
            return this._createComment(this.mf.newTopicModel("zukunftswerk.comment", this.mf.newChildTopicsModel().set("zukunftswerk.comment.de", (Object)comment)), refTopicIds, fileTopicIds);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating monolingual comment failed, comment=\"" + comment + "\", refTopicIds=" + refTopicIds + ", fileTopicIds=" + fileTopicIds, e);
        }
    }

    @Override
    @GET
    @Path(value="/users")
    public List<Topic> getAllUsers() {
        try {
            return this.dmx.getTopicsByType("dmx.accesscontrol.username");
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving all ZW users failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/admin/workspaces")
    public List<RelatedTopic> getAllZWWorkspaces() {
        try {
            return DMXUtils.loadChildTopics((List)this.zwPluginTopic.getRelatedTopics("zukunftswerk.shared_workspace", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace"));
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving all ZW workspaces failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/admin/user/{username}/workspaces")
    public List<RelatedTopic> getZWWorkspacesOfUser(@PathParam(value="username") String username) {
        try {
            Topic usernameTopic = this.acs.getUsernameTopic(username);
            if (usernameTopic == null) {
                throw new IllegalArgumentException("No such user: \"" + username + "\"");
            }
            List<RelatedTopic> workspaces = this.getZWWorkspaces(usernameTopic);
            Assoc membership = this.acs.getMembership(username, this.teamWorkspace.getId());
            if (membership != null) {
                workspaces.add((RelatedTopic)membership.getDMXObjectByType("dmx.workspaces.workspace"));
            }
            return workspaces;
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving ZW workspaces of user \"" + username + "\" failed", e);
        }
    }

    @Override
    public List<RelatedTopic> getZWTeamMembers() {
        return this.acs.getMemberships(this.teamWorkspace.getId());
    }

    @Override
    @PUT
    @Path(value="/admin/workspace/{workspaceId}")
    @Transactional
    public List<RelatedTopic> bulkUpdateWorkspaceMemberships(@PathParam(value="workspaceId") long workspaceId, @QueryParam(value="addUserIds1") IdList addUserIds1, @QueryParam(value="removeUserIds1") IdList removeUserIds1, @QueryParam(value="addUserIds2") IdList addUserIds2, @QueryParam(value="removeUserIds2") IdList removeUserIds2) {
        try {
            Assoc assoc;
            String username;
            long userId;
            Iterator iterator;
            List users = this.acs.bulkUpdateMemberships(workspaceId, addUserIds1, removeUserIds1);
            if (removeUserIds2 != null) {
                iterator = removeUserIds2.iterator();
                while (iterator.hasNext()) {
                    userId = (Long)iterator.next();
                    username = this.getUsername(userId);
                    assoc = this.acs.getMembership(username, workspaceId);
                    if (assoc == null) continue;
                    this.facets.updateFacet((DMXObject)assoc, "zukunftswerk.editor_facet", this.mf.newFacetValueModel("zukunftswerk.editor").set((Object)false));
                }
            }
            if (addUserIds2 != null) {
                iterator = addUserIds2.iterator();
                while (iterator.hasNext()) {
                    userId = (Long)iterator.next();
                    username = this.getUsername(userId);
                    assoc = this.acs.getMembership(username, workspaceId);
                    if (assoc == null) continue;
                    this.facets.updateFacet((DMXObject)assoc, "zukunftswerk.editor_facet", this.mf.newFacetValueModel("zukunftswerk.editor").set((Object)true));
                }
            }
            return users;
        }
        catch (Exception e) {
            throw new RuntimeException("Bulk membership update for ZW workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/admin/user/{username}")
    @Transactional
    public List<RelatedTopic> bulkUpdateUserMemberships(@PathParam(value="username") String username, @QueryParam(value="addWorkspaceIds1") IdList addWorkspaceIds1, @QueryParam(value="removeWorkspaceIds1") IdList removeWorkspaceIds1, @QueryParam(value="addWorkspaceIds2") IdList addWorkspaceIds2, @QueryParam(value="removeWorkspaceIds2") IdList removeWorkspaceIds2) {
        this.acs.bulkUpdateMemberships(username, addWorkspaceIds1, removeWorkspaceIds1);
        return this.getZWWorkspacesOfUser(username);
    }

    @Override
    @POST
    @Path(value="/admin/workspace")
    @Transactional
    public Topic createZWWorkspace(@QueryParam(value="nameDe") String nameDe, @QueryParam(value="nameFr") String nameFr) {
        try {
            Topic workspace = this.ws.createWorkspace(nameDe, null, SharingMode.COLLABORATIVE);
            workspace.update(this.mf.newChildTopicsModel().set("dmx.workspaces.workspace_name#zukunftswerk.de", (Object)nameDe).set("dmx.workspaces.workspace_name#zukunftswerk.fr", (Object)nameFr));
            long workspaceId = workspace.getId();
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(workspaceId, () -> {
                this.dmx.createAssoc(this.mf.newAssocModel("zukunftswerk.shared_workspace", (PlayerModel)this.mf.newTopicPlayerModel("systems.dmx.zukunftswerk", "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(workspaceId, "dmx.core.default")));
                return null;
            });
            List<RelatedTopic> usernames = this.getZWTeamMembers();
            this.logger.info("### Inviting " + usernames.size() + " Team members to workspace \"" + workspace.getSimpleValue() + "\"");
            this.acs.bulkUpdateMemberships(workspaceId, new IdList(usernames), null);
            return workspace;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating a ZW workspace failed", e);
        }
    }

    private TopicModel createBilingualTopicModel(String topicTypeUri, String text) {
        Translation translation = (Translation)this.deepls.translate(text, "en").get(0);
        String origLang = translation.detectedSourceLang.toLowerCase();
        String targetLang = this.targetLang(origLang);
        String translatedComment = ((Translation)this.deepls.translate((String)text, (String)targetLang).get((int)0)).text;
        return this.mf.newTopicModel(topicTypeUri, this.mf.newChildTopicsModel().set(topicTypeUri + "." + origLang, (Object)text).set(topicTypeUri + "." + targetLang, (Object)translatedComment).set("zukunftswerk.language#zukunftswerk.original_language", (Object)origLang));
    }

    private String targetLang(String origLang) {
        if (origLang.equals("de")) {
            return "fr";
        }
        if (origLang.equals("fr")) {
            return "de";
        }
        throw new RuntimeException("Unsupported original language: \"" + origLang + "\" (detected)");
    }

    private Topic _createComment(TopicModel commentModel, IdList refTopicIds, IdList fileTopicIds) {
        Iterator iterator;
        if (refTopicIds != null) {
            iterator = refTopicIds.iterator();
            while (iterator.hasNext()) {
                long refTopicId = (Long)iterator.next();
                String refTypeUri = this.dmx.getTopic(refTopicId).getTypeUri();
                commentModel.getChildTopics().setRef(refTypeUri, refTopicId);
            }
        }
        if (fileTopicIds != null) {
            iterator = fileTopicIds.iterator();
            while (iterator.hasNext()) {
                long fileTopicId = (Long)iterator.next();
                commentModel.getChildTopics().addRef("dmx.files.file#zukunftswerk.attachment", fileTopicId);
            }
        }
        Topic commentTopic = this.dmx.createTopic(commentModel);
        this.acs.enrichWithUserInfo((DMXObject)commentTopic);
        this.tss.enrichWithTimestamps((DMXObject)commentTopic);
        this.me.addComment(this.workspaceId(), commentTopic);
        this.sendNotificationMail(commentTopic);
        return commentTopic;
    }

    private void sendNotificationMail(Topic comment) {
        String commentDe = comment.getChildTopics().getString("zukunftswerk.comment.de");
        String commentFr = comment.getChildTopics().getString("zukunftswerk.comment.fr", "");
        String workspace = this.dmx.getTopic(this.workspaceId()).getSimpleValue().toString();
        String creator = comment.getModel().getChildTopics().getString("dmx.accesscontrol.creator");
        String message = "\rNEW COMMENT\r\rWorkspace: " + workspace + "\rAuthor: " + creator + "\r\r----------------\r" + commentDe + "\r----------------\r" + commentFr + "\r----------------\r";
        this.forEachTeamMember(username -> this.sendmail.doEmailRecipient("ZW Platform Activity", message, username.getSimpleValue().toString()));
    }

    private void forEachTeamMember(Consumer<Topic> consumer) {
        this.getZWTeamMembers().stream().forEach(username -> consumer.accept((Topic)username));
    }

    private void processTeamMembership(Assoc assoc, Consumer<String> consumer) {
        Topic workspace;
        if (assoc.getTypeUri().equals("dmx.accesscontrol.membership") && (workspace = (Topic)assoc.getDMXObjectByType("dmx.workspaces.workspace")).getUri().equals("zukunftswerk.team")) {
            String username = assoc.getDMXObjectByType("dmx.accesscontrol.username").getSimpleValue().toString();
            consumer.accept(username);
        }
    }

    private List<RelatedTopic> getZWWorkspaces(Topic username) {
        return DMXUtils.loadChildTopics(username.getRelatedTopics("dmx.accesscontrol.membership", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace").stream().filter(this::isZWWorkspace).collect(Collectors.toList()));
    }

    private boolean isZWWorkspace(Topic workspace) {
        return this.dmx.getAssocBetweenTopicAndTopic("zukunftswerk.shared_workspace", workspace.getId(), this.zwPluginTopic.getId(), "dmx.core.default", "dmx.core.default") != null;
    }

    private long workspaceId() {
        return Cookies.get().getLong("dmx_workspace_id");
    }

    private String getUsername(long id) {
        Topic username = this.dmx.getTopic(id);
        String typeUri = username.getTypeUri();
        if (!typeUri.equals("dmx.accesscontrol.username")) {
            throw new IllegalArgumentException("Topic " + id + " is not a Username (but a \"" + typeUri + "\")");
        }
        return username.getSimpleValue().toString();
    }
}

