/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.zukunftswerk;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.CoreService;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.timestamps.TimestampsService;
import systems.dmx.workspaces.WorkspacesService;

class EmailDigests {
    static final long MILLISECS_PER_DAY = 86400000L;
    private CoreService dmx;
    private AccessControlService acs;
    private WorkspacesService ws;
    private TimestampsService timestamps;
    private SendmailService sendmail;
    private Topic teamWorkspace;
    private int digestCount;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    EmailDigests(CoreService dmx, AccessControlService acs, WorkspacesService ws, TimestampsService timestamps, SendmailService sendmail, Topic teamWorkspace) {
        this.dmx = dmx;
        this.acs = acs;
        this.ws = ws;
        this.timestamps = timestamps;
        this.sendmail = sendmail;
        this.teamWorkspace = teamWorkspace;
    }

    void startTimedTask() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 6);
        cal.set(12, 0);
        cal.set(13, 0);
        this.logger.info("### Sheduling email-digests task for daily execution at 6am, first execution: " + cal.getTime());
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                EmailDigests.this.sendEmailDigests();
            }
        }, cal.getTime(), 86400000L);
    }

    private void sendEmailDigests() {
        try {
            long to = System.currentTimeMillis();
            long from = to - 86400000L;
            this.digestCount = 0;
            this.timestamps.getTopicsByModificationTime(from, to).stream().filter(this::isComment).collect(Collectors.groupingBy(this::workspace)).forEach((workspaceId, comments) -> {
                String workspace = this.dmx.getTopic(workspaceId.longValue()).getSimpleValue().toString();
                String subject = "[ZW Platform] " + workspace;
                StringBuilder message = new StringBuilder();
                this.logger.info("### Sending email digest for workspace \"" + workspace + "\" (" + comments.size() + " comments)");
                comments.forEach(comment -> {
                    this.timestamps.enrichWithTimestamps((DMXObject)comment);
                    this.acs.enrichWithUserInfo((DMXObject)comment);
                });
                comments.sort((c1, c2) -> {
                    int m1 = c1.getModel().getChildTopics().getInt("dmx.timestamps.modified");
                    int m2 = c2.getModel().getChildTopics().getInt("dmx.timestamps.modified");
                    return m1 - m2;
                });
                comments.forEach(comment -> message.append(this.emailMessage((Topic)comment)));
                this.forEachTeamMember(username -> {
                    this.logger.info("### Sending email to " + username + ", subject=\"" + subject + "\", message=\"" + message.toString() + "\"");
                    this.sendmail.doEmailRecipient(subject, message.toString(), username);
                });
                ++this.digestCount;
            });
            if (this.digestCount == 0) {
                this.logger.info("### Sending email digests SKIPPED -- no new/changed comments in last 24 hours");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Sending email digests failed", e);
        }
    }

    private boolean isComment(Topic topic) {
        return topic.getTypeUri().equals("zukunftswerk.comment");
    }

    private Long workspace(Topic comment) {
        return this.ws.getAssignedWorkspace(comment.getId()).getId();
    }

    private String emailMessage(Topic comment) {
        String commentDe = comment.getChildTopics().getString("zukunftswerk.comment.de");
        String commentFr = comment.getChildTopics().getString("zukunftswerk.comment.fr", "");
        String creator = comment.getModel().getChildTopics().getString("dmx.accesscontrol.creator");
        long modified = comment.getModel().getChildTopics().getLong("dmx.timestamps.modified");
        return "<br>\rAuthor: " + creator + "<br>\rDate: " + new Date(modified) + "<br><br>\r\r" + commentDe + "\r>>>\r" + commentFr + "\r------------------------------------------------<br>\r";
    }

    private void forEachTeamMember(Consumer<String> consumer) {
        this.getZWTeamMembers().stream().forEach(username -> consumer.accept(username.getSimpleValue().toString()));
    }

    private List<RelatedTopic> getZWTeamMembers() {
        return this.acs.getMemberships(this.teamWorkspace.getId());
    }
}

