/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.zwmigrator.migrations;

import java.util.List;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.service.Migration;

public class Migration2
extends Migration {
    public void run() {
        this.transformWorkspaces();
        this.retypeBilingualTopics("note");
        this.retypeBilingualTopics("textblock");
        this.retypeTopics("language");
        this.retypeTopics("translation_edited");
        this.retypeTopics("locked");
        this.retypeAssocs("shared_workspace");
        Topic plugin = this.dmx.getTopicByUri("systems.dmx.zukunftswerk");
        plugin.update(this.mf.newChildTopicsModel().set("dmx.core.plugin_name", (Object)"DMX Linqa").set("dmx.core.plugin_symbolic_name", (Object)"systems.dmx.linqa").set("dmx.core.plugin_migration_nr", (Object)2));
        plugin.setUri("systems.dmx.linqa");
    }

    private void retypeBilingualTopics(String item) {
        this.dmx.getTopicsByType("zukunftswerk." + item).stream().forEach(topic -> {
            RelatedTopic origLang;
            ChildTopics ct = topic.getChildTopics();
            RelatedTopic de = ct.getTopic("zukunftswerk." + item + ".de");
            RelatedTopic fr = ct.getTopicOrNull("zukunftswerk." + item + ".fr");
            de.setTypeUri("linqa." + item + "_text");
            de.getRelatingAssoc().setTypeUri("linqa.lang1");
            if (fr != null) {
                fr.setTypeUri("linqa." + item + "_text");
                fr.getRelatingAssoc().setTypeUri("linqa.lang2");
            }
            if ((origLang = ct.getTopicOrNull("zukunftswerk.language#zukunftswerk.original_language")) != null) {
                origLang.getRelatingAssoc().setTypeUri("linqa.original_language");
            }
            topic.setTypeUri("linqa." + item);
        });
    }

    private void retypeTopics(String item) {
        this.dmx.getTopicsByType("zukunftswerk." + item).stream().forEach(topic -> topic.setTypeUri("linqa." + item));
    }

    private void retypeAssocs(String item) {
        this.dmx.getAssocsByType("zukunftswerk." + item).stream().forEach(assoc -> assoc.setTypeUri("linqa." + item));
    }

    private void transformWorkspaces() {
        Topic teamWs = this.dmx.getTopicByUri("zukunftswerk.team");
        teamWs.update((DMXObjectModel)this.mf.newTopicModel("linqa.admin_ws", "dmx.workspaces.workspace", this.mf.newChildTopicsModel().set("dmx.workspaces.workspace_name", (Object)"Linqa Administration").set("dmx.workspaces.workspace_name#zukunftswerk.de", (Object)"Linqa Administration")));
        this.transformWorkspaceName(teamWs);
        this.getAllZWWorkspaces().stream().forEach(this::transformWorkspaceName);
        TopicType type = this.dmx.getTopicType("dmx.workspaces.workspace");
        String compDefUri = "dmx.core.assoc_type#dmx.core.custom_assoc_type";
        type.getCompDef("dmx.workspaces.workspace_name#zukunftswerk.de").update(this.mf.newChildTopicsModel().setRef(compDefUri, "linqa.lang1"));
        type.getCompDef("dmx.workspaces.workspace_name#zukunftswerk.fr").update(this.mf.newChildTopicsModel().setRef(compDefUri, "linqa.lang2"));
    }

    private void transformWorkspaceName(Topic ws) {
        ChildTopics ct = ws.getChildTopics();
        RelatedTopic de = ct.getTopicOrNull("dmx.workspaces.workspace_name#zukunftswerk.de");
        RelatedTopic fr = ct.getTopicOrNull("dmx.workspaces.workspace_name#zukunftswerk.fr");
        if (de != null) {
            de.getRelatingAssoc().setTypeUri("linqa.lang1");
        }
        if (fr != null) {
            fr.getRelatingAssoc().setTypeUri("linqa.lang2");
        }
    }

    private List<RelatedTopic> getAllZWWorkspaces() {
        return this.dmx.getTopicByUri("systems.dmx.zukunftswerk").getRelatedTopics("zukunftswerk.shared_workspace", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace");
    }
}

