/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.zwmigrator.migrations;

import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.workspaces.WorkspacesService;

public class Migration2
extends Migration {
    @Inject
    private WorkspacesService wss;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.transformProperties();
        this.retypeBilingualTopics("note");
        this.retypeBilingualTopics("textblock");
        this.retypeTopics("language");
        this.retypeTopics("translation_edited");
        this.retypeTopics("locked");
        this.retypeAssocs("shared_workspace");
        this.transformWorkspaces();
        this.transformPluginTopic();
    }

    private void transformProperties() {
        this.forAllWorkspaces(ws -> {
            String wsName = ws.getSimpleValue().toString();
            this.logger.info("---------------- \"" + wsName + "\" ----------------");
            List topicmaps = this.wss.getAssignedTopics(ws.getId(), "dmx.topicmaps.topicmap");
            if (topicmaps.size() != 1) {
                throw new RuntimeException("Workspace " + ws.getId() + " has " + topicmaps.size() + " topicmaps, expected is 1");
            }
            Topic topicmap = (Topic)topicmaps.get(0);
            topicmap.getRelatedTopics("dmx.topicmaps.topicmap_context", "dmx.core.default", "dmx.topicmaps.topicmap_content", null).stream().forEach(topic -> {
                Assoc assoc = topic.getRelatingAssoc();
                if (assoc.hasProperty("zukunftswerk.color")) {
                    assoc.setProperty("linqa.color", assoc.getProperty("zukunftswerk.color"), false);
                    assoc.removeProperty("zukunftswerk.color");
                }
                if (assoc.hasProperty("zukunftswerk.angle")) {
                    assoc.setProperty("linqa.angle", assoc.getProperty("zukunftswerk.angle"), false);
                    assoc.removeProperty("zukunftswerk.angle");
                }
            });
        });
    }

    private void retypeBilingualTopics(String item) {
        this.dmx.getTopicsByType("zukunftswerk." + item).stream().forEach(topic -> {
            RelatedTopic origLang;
            ChildTopics ct = topic.getChildTopics();
            RelatedTopic de = ct.getTopic("zukunftswerk." + item + ".de");
            RelatedTopic fr = ct.getTopicOrNull("zukunftswerk." + item + ".fr");
            de.setTypeUri("linqa." + item + "_text");
            de.getRelatingAssoc().setTypeUri("linqa.lang1");
            if (fr != null) {
                fr.setTypeUri("linqa." + item + "_text");
                fr.getRelatingAssoc().setTypeUri("linqa.lang2");
            }
            if ((origLang = ct.getTopicOrNull("zukunftswerk.language#zukunftswerk.original_language")) != null) {
                origLang.getRelatingAssoc().setTypeUri("linqa.original_language");
            }
            topic.setTypeUri("linqa." + item);
        });
    }

    private void retypeTopics(String item) {
        this.dmx.getTopicsByType("zukunftswerk." + item).stream().forEach(topic -> topic.setTypeUri("linqa." + item));
    }

    private void retypeAssocs(String item) {
        this.dmx.getAssocsByType("zukunftswerk." + item).stream().forEach(assoc -> assoc.setTypeUri("linqa." + item));
    }

    private void transformWorkspaces() {
        this.forAllWorkspaces(this::transformWorkspaceName);
        TopicType type = this.dmx.getTopicType("dmx.workspaces.workspace");
        String compDefUri = "dmx.core.assoc_type#dmx.core.custom_assoc_type";
        type.getCompDef("dmx.workspaces.workspace_name#zukunftswerk.de").update(this.mf.newChildTopicsModel().setRef(compDefUri, "linqa.lang1"));
        type.getCompDef("dmx.workspaces.workspace_name#zukunftswerk.fr").update(this.mf.newChildTopicsModel().setRef(compDefUri, "linqa.lang2"));
        this.dmx.getTopicByUri("zukunftswerk.team").update((DMXObjectModel)this.mf.newTopicModel("linqa.admin_ws", "dmx.workspaces.workspace", this.mf.newChildTopicsModel().set("dmx.workspaces.workspace_name", (Object)"Linqa Administration").set("dmx.workspaces.workspace_name#zukunftswerk.de", (Object)"Linqa Administration")));
    }

    private void transformWorkspaceName(Topic ws) {
        ChildTopics ct = ws.getChildTopics();
        RelatedTopic de = ct.getTopicOrNull("dmx.workspaces.workspace_name#zukunftswerk.de");
        RelatedTopic fr = ct.getTopicOrNull("dmx.workspaces.workspace_name#zukunftswerk.fr");
        if (de != null) {
            de.getRelatingAssoc().setTypeUri("linqa.lang1");
        }
        if (fr != null) {
            fr.getRelatingAssoc().setTypeUri("linqa.lang2");
        }
    }

    private void forAllWorkspaces(Consumer<Topic> consumer) {
        consumer.accept(this.dmx.getTopicByUri("zukunftswerk.team"));
        this.getAllZWWorkspaces().stream().forEach(consumer);
    }

    private List<RelatedTopic> getAllZWWorkspaces() {
        return this.dmx.getTopicByUri("systems.dmx.zukunftswerk").getRelatedTopics("zukunftswerk.shared_workspace", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace");
    }

    private void transformPluginTopic() {
        this.dmx.getTopicByUri("systems.dmx.zukunftswerk").update((DMXObjectModel)this.mf.newTopicModel("systems.dmx.linqa", "dmx.core.plugin", this.mf.newChildTopicsModel().set("dmx.core.plugin_name", (Object)"DMX Linqa").set("dmx.core.plugin_symbolic_name", (Object)"systems.dmx.linqa").set("dmx.core.plugin_migration_nr", (Object)2)));
    }
}

