/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.zwmigrator.migrations;

import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.workspaces.WorkspacesService;

public class Migration2
extends Migration {
    @Inject
    private WorkspacesService wss;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.transformProperties();
        this.transformDocumentRefs();
        long comments = this.retypeBilingualTopics("comment");
        long documents = this.retypeBilingualTopics("document", "document_name", null);
        long notes = this.retypeBilingualTopics("note");
        long textblocks = this.retypeBilingualTopics("textblock");
        long headings = this.retypeBilingualTopics("label", null, "heading");
        long arrows = this.retypeTopics("arrow");
        this.retypeTopics("viewport");
        this.retypeTopics("language");
        this.retypeTopics("translation_edited");
        this.retypeTopics("locked");
        this.retypeAssocs("shared_workspace");
        this.retypeAssocs("attachment");
        this.retypeAssocs("original_language");
        long workspaces = this.transformWorkspaces();
        this.transformPluginTopic();
        this.logger.info("##### ZW->Linqa migration complete #####\n  Workspaces: " + workspaces + "\n  Comments: " + comments + "\n  Documents: " + documents + "\n  Notes: " + notes + "\n  Textblocks: " + textblocks + "\n  Headings: " + headings + "\n  Arrows: " + arrows);
    }

    private void transformProperties() {
        this.forAllWorkspaces(ws -> {
            String wsName = ws.getSimpleValue().toString();
            this.logger.info("---------------- \"" + wsName + "\" ----------------");
            List topicmaps = this.wss.getAssignedTopics(ws.getId(), "dmx.topicmaps.topicmap");
            if (topicmaps.size() != 1) {
                throw new RuntimeException("Workspace " + ws.getId() + " has " + topicmaps.size() + " topicmaps, expected is 1");
            }
            Topic topicmap = (Topic)topicmaps.get(0);
            topicmap.getRelatedTopics("dmx.topicmaps.topicmap_context", "dmx.core.default", "dmx.topicmaps.topicmap_content", null).stream().forEach(topic -> {
                Assoc assoc = topic.getRelatingAssoc();
                if (assoc.hasProperty("zukunftswerk.color")) {
                    assoc.setProperty("linqa.color", assoc.getProperty("zukunftswerk.color"), false);
                    assoc.removeProperty("zukunftswerk.color");
                }
                if (assoc.hasProperty("zukunftswerk.angle")) {
                    assoc.setProperty("linqa.angle", assoc.getProperty("zukunftswerk.angle"), false);
                    assoc.removeProperty("zukunftswerk.angle");
                }
            });
        });
    }

    private void transformDocumentRefs() {
        this.dmx.getTopicsByType("zukunftswerk.document").stream().forEach(topic -> {
            ChildTopics ct = topic.getChildTopics();
            RelatedTopic de = ct.getTopicOrNull("dmx.files.file#zukunftswerk.de");
            RelatedTopic fr = ct.getTopicOrNull("dmx.files.file#zukunftswerk.fr");
            if (de != null) {
                de.getRelatingAssoc().setTypeUri("linqa.lang1");
            }
            if (fr != null) {
                fr.getRelatingAssoc().setTypeUri("linqa.lang2");
            }
        });
    }

    private long retypeBilingualTopics(String item) {
        return this.retypeBilingualTopics(item, null, null);
    }

    private long retypeBilingualTopics(String item, String biItem, String targetItem) {
        return this.dmx.getTopicsByType("zukunftswerk." + item).stream().filter(topic -> {
            String _biItem = biItem != null ? biItem : item;
            RelatedTopic de = this.getRelatedTopic((Topic)topic, "zukunftswerk." + _biItem + ".de");
            RelatedTopic fr = this.getRelatedTopic((Topic)topic, "zukunftswerk." + _biItem + ".fr");
            this.logger.fine("-------> " + topic.getSimpleValue() + " (" + topic.getId() + ", " + (de != null) + ", " + (fr != null) + ") \"" + this.wss.getAssignedWorkspace(topic.getId()).getSimpleValue() + "\"");
            String _targetBiItem = "linqa." + (biItem != null ? biItem : (targetItem != null ? targetItem : item) + "_text");
            if (de != null) {
                de.setTypeUri(_targetBiItem);
                de.getRelatingAssoc().setTypeUri("linqa.lang1");
            }
            if (fr != null) {
                fr.setTypeUri(_targetBiItem);
                fr.getRelatingAssoc().setTypeUri("linqa.lang2");
            }
            String _targetItem = targetItem != null ? targetItem : item;
            topic.setTypeUri("linqa." + _targetItem);
            return true;
        }).count();
    }

    private RelatedTopic getRelatedTopic(Topic topic, String childTypeUri) {
        return topic.getRelatedTopic("dmx.core.composition", "dmx.core.parent", "dmx.core.child", childTypeUri);
    }

    private long retypeTopics(String item) {
        return this.dmx.getTopicsByType("zukunftswerk." + item).stream().filter(topic -> {
            topic.setTypeUri("linqa." + item);
            return true;
        }).count();
    }

    private long retypeAssocs(String item) {
        return this.dmx.getAssocsByType("zukunftswerk." + item).stream().filter(assoc -> {
            assoc.setTypeUri("linqa." + item);
            return true;
        }).count();
    }

    private long transformWorkspaces() {
        long count = this.forAllWorkspaces(this::transformWorkspaceName);
        TopicType type = this.dmx.getTopicType("dmx.workspaces.workspace");
        String compDefUri = "dmx.core.assoc_type#dmx.core.custom_assoc_type";
        type.getCompDef("dmx.workspaces.workspace_name#zukunftswerk.de").update(this.mf.newChildTopicsModel().setRef(compDefUri, "linqa.lang1"));
        type.getCompDef("dmx.workspaces.workspace_name#zukunftswerk.fr").update(this.mf.newChildTopicsModel().setRef(compDefUri, "linqa.lang2"));
        this.dmx.getTopicByUri("zukunftswerk.team").update((DMXObjectModel)this.mf.newTopicModel("linqa.admin_ws", "dmx.workspaces.workspace", this.mf.newChildTopicsModel().set("dmx.workspaces.workspace_name", (Object)"Linqa Administration").set("dmx.workspaces.workspace_name#zukunftswerk.de", (Object)"Linqa Administration")));
        return count;
    }

    private void transformWorkspaceName(Topic ws) {
        ChildTopics ct = ws.getChildTopics();
        RelatedTopic de = ct.getTopicOrNull("dmx.workspaces.workspace_name#zukunftswerk.de");
        RelatedTopic fr = ct.getTopicOrNull("dmx.workspaces.workspace_name#zukunftswerk.fr");
        if (de != null) {
            de.getRelatingAssoc().setTypeUri("linqa.lang1");
        }
        if (fr != null) {
            fr.getRelatingAssoc().setTypeUri("linqa.lang2");
        }
    }

    private long forAllWorkspaces(Consumer<Topic> consumer) {
        consumer.accept(this.dmx.getTopicByUri("zukunftswerk.team"));
        return this.getAllZWWorkspaces().stream().filter(ws -> {
            consumer.accept((Topic)ws);
            return true;
        }).count() + 1L;
    }

    private List<RelatedTopic> getAllZWWorkspaces() {
        return this.dmx.getTopicByUri("systems.dmx.zukunftswerk").getRelatedTopics("zukunftswerk.shared_workspace", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace");
    }

    private void transformPluginTopic() {
        this.dmx.getTopicByUri("systems.dmx.zukunftswerk").update((DMXObjectModel)this.mf.newTopicModel("systems.dmx.linqa", "dmx.core.plugin", this.mf.newChildTopicsModel().set("dmx.core.plugin_name", (Object)"DMX Linqa").set("dmx.core.plugin_symbolic_name", (Object)"systems.dmx.linqa").set("dmx.core.plugin_migration_nr", (Object)2)));
    }
}

