/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.zwmigrator;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.workspaces.WorkspacesService;

public class ZWMigratorThread
extends Thread {
    private WorkspacesService wss;
    private CoreService dmx;
    private ModelFactory mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ZWMigratorThread(WorkspacesService wss, CoreService dmx, ModelFactory mf) {
        this.wss = wss;
        this.dmx = dmx;
        this.mf = mf;
    }

    @Override
    public void run() {
        this.logger.info("### Starting ZW->Linqa migration (in background) ###");
        long time = System.currentTimeMillis();
        long comments = this.retypeBilingualAssocs("comment");
        long documents = this.retypeBilingualAssocs("document", "document_name");
        long notes = this.retypeBilingualAssocs("note");
        long textblocks = this.retypeBilingualAssocs("textblock");
        long headings = this.retypeBilingualAssocs("label");
        this.retypeTopics("comment");
        this.retypeTopics("comment.de", "comment_text");
        this.retypeTopics("comment.fr", "comment_text");
        this.retypeTopics("document");
        this.retypeTopics("document_name.de", "document_name");
        this.retypeTopics("document_name.fr", "document_name");
        this.retypeTopics("note");
        this.retypeTopics("note.de", "note_text");
        this.retypeTopics("note.fr", "note_text");
        this.retypeTopics("textblock");
        this.retypeTopics("textblock.de", "textblock_text");
        this.retypeTopics("textblock.fr", "textblock_text");
        this.retypeTopics("label", "heading");
        this.retypeTopics("label.de", "heading_text");
        this.retypeTopics("label.fr", "heading_text");
        long arrows = this.retypeTopics("arrow");
        this.retypeTopics("viewport");
        this.retypeTopics("language");
        this.retypeTopics("translation_edited");
        this.retypeTopics("locked");
        this.retypeTopics("editor");
        this.retypeTopics("show_email_address");
        long workspaces = this.transformProperties();
        this.transformAdminProperties();
        this.transformTeamWorkspace();
        this.transformWorkspaceModel();
        this.transformPluginTopic();
        this.retypeAssocs("shared_workspace");
        this.retypeAssocs("attachment");
        this.retypeAssocs("original_language");
        this.retypeAssocs("de", "lang1");
        this.retypeAssocs("fr", "lang2");
        this.deleteZukunftswerkModel();
        float sec = (float)(System.currentTimeMillis() - time) / 1000.0f;
        this.logger.info("##### ZW->Linqa migration complete (" + sec + " sec) #####\n  Workspaces: " + workspaces + "\n  Comments: " + comments + "\n  Documents: " + documents + "\n  Notes: " + notes + "\n  Textblocks: " + textblocks + "\n  Headings: " + headings + "\n  Arrows: " + arrows);
    }

    private long retypeBilingualAssocs(String item) {
        return this.retypeBilingualAssocs(item, null);
    }

    private long retypeBilingualAssocs(String item, String biItem) {
        return this.tx(() -> this.dmx.getTopicsByType("zukunftswerk." + item).stream().filter(topic -> {
            String _biItem = biItem != null ? biItem : item;
            RelatedTopic de = this.getRelatedTopic((Topic)topic, "zukunftswerk." + _biItem + ".de");
            RelatedTopic fr = this.getRelatedTopic((Topic)topic, "zukunftswerk." + _biItem + ".fr");
            if (de != null) {
                de.getRelatingAssoc().setTypeUri("linqa.lang1");
            }
            if (fr != null) {
                fr.getRelatingAssoc().setTypeUri("linqa.lang2");
            }
            return true;
        }).count());
    }

    private RelatedTopic getRelatedTopic(Topic topic, String childTypeUri) {
        return topic.getRelatedTopic("dmx.core.composition", "dmx.core.parent", "dmx.core.child", childTypeUri);
    }

    private long retypeTopics(String item) {
        return this.retypeTopics(item, null);
    }

    private long retypeTopics(String item, String targetItem) {
        return this.tx(() -> {
            String typeUri = "linqa." + (targetItem != null ? targetItem : item);
            return this.dmx.getTopicsByType("zukunftswerk." + item).stream().filter(topic -> {
                topic.setTypeUri(typeUri);
                return true;
            }).count();
        });
    }

    private long retypeAssocs(String item) {
        return this.retypeAssocs(item, null);
    }

    private long retypeAssocs(String item, String targetItem) {
        return this.tx(() -> {
            String typeUri = "linqa." + (targetItem != null ? targetItem : item);
            return this.dmx.getAssocsByType("zukunftswerk." + item).stream().filter(assoc -> {
                assoc.setTypeUri(typeUri);
                return true;
            }).count();
        });
    }

    private long transformProperties() {
        return this.forAllWorkspaces(ws -> this.tx(() -> {
            String wsName = ws.getSimpleValue().toString();
            this.logger.info("---------------- \"" + wsName + "\" ----------------");
            List topicmaps = this.wss.getAssignedTopics(ws.getId(), "dmx.topicmaps.topicmap");
            if (topicmaps.size() != 1) {
                throw new RuntimeException("Workspace " + ws.getId() + " has " + topicmaps.size() + " topicmaps, expected is 1");
            }
            Topic topicmap = (Topic)topicmaps.get(0);
            topicmap.getRelatedTopics("dmx.topicmaps.topicmap_context", "dmx.core.default", "dmx.topicmaps.topicmap_content", null).stream().forEach(topic -> {
                Assoc assoc = topic.getRelatingAssoc();
                this.transformProperty((DMXObject)assoc, "zukunftswerk.color", "linqa.color");
                this.transformProperty((DMXObject)assoc, "zukunftswerk.angle", "linqa.angle");
            });
            return null;
        }));
    }

    private long forAllWorkspaces(Consumer<Topic> consumer) {
        consumer.accept(this.dmx.getTopicByUri("zukunftswerk.team"));
        return this.getAllZWWorkspaces().stream().filter(ws -> {
            consumer.accept((Topic)ws);
            return true;
        }).count() + 1L;
    }

    private List<RelatedTopic> getAllZWWorkspaces() {
        return this.dmx.getTopicByUri("systems.dmx.zukunftswerk").getRelatedTopics("zukunftswerk.shared_workspace", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace");
    }

    private void transformAdminProperties() {
        this.tx(() -> {
            this.dmx.getTopicsByType("dmx.accesscontrol.username").stream().forEach(topic -> this.transformProperty((DMXObject)topic, "zukunftswerk.user_active", "linqa.user_active"));
            return null;
        });
    }

    private void transformProperty(DMXObject object, String srcProp, String targetProp) {
        if (object.hasProperty(srcProp)) {
            object.setProperty(targetProp, object.getProperty(srcProp), false);
            object.removeProperty(srcProp);
        }
    }

    private void transformTeamWorkspace() {
        this.tx(() -> {
            this.dmx.getTopicByUri("zukunftswerk.team").setUri("linqa.admin_ws");
            return null;
        });
    }

    private void transformWorkspaceModel() {
        this.tx(() -> {
            TopicType type = this.dmx.getTopicType("dmx.workspaces.workspace");
            String compDefUri = "dmx.core.assoc_type#dmx.core.custom_assoc_type";
            type.getCompDef("dmx.workspaces.workspace_name#zukunftswerk.de").update(this.mf.newChildTopicsModel().setRef(compDefUri, "linqa.lang1"));
            type.getCompDef("dmx.workspaces.workspace_name#zukunftswerk.fr").update(this.mf.newChildTopicsModel().setRef(compDefUri, "linqa.lang2"));
            return null;
        });
    }

    private void transformPluginTopic() {
        this.tx(() -> {
            this.dmx.getTopicByUri("systems.dmx.zukunftswerk").update((DMXObjectModel)this.mf.newTopicModel("systems.dmx.linqa", "dmx.core.plugin", this.mf.newChildTopicsModel().set("dmx.core.plugin_name", (Object)"DMX Linqa").set("dmx.core.plugin_symbolic_name", (Object)"systems.dmx.linqa").set("dmx.core.plugin_migration_nr", (Object)2)));
            return null;
        });
    }

    private void deleteZukunftswerkModel() {
        this.deleteTopicType("zukunftswerk.document");
        this.deleteTopicType("zukunftswerk.document_name.de");
        this.deleteTopicType("zukunftswerk.document_name.fr");
        this.deleteTopicType("zukunftswerk.note");
        this.deleteTopicType("zukunftswerk.note.de");
        this.deleteTopicType("zukunftswerk.note.fr");
        this.deleteTopicType("zukunftswerk.textblock");
        this.deleteTopicType("zukunftswerk.textblock.de");
        this.deleteTopicType("zukunftswerk.textblock.fr");
        this.deleteTopicType("zukunftswerk.label");
        this.deleteTopicType("zukunftswerk.label.de");
        this.deleteTopicType("zukunftswerk.label.fr");
        this.deleteTopicType("zukunftswerk.arrow");
        this.deleteTopicType("zukunftswerk.comment");
        this.deleteTopicType("zukunftswerk.comment.de");
        this.deleteTopicType("zukunftswerk.comment.fr");
        this.deleteTopicType("zukunftswerk.language");
        this.deleteTopicType("zukunftswerk.translation_edited");
        this.deleteTopicType("zukunftswerk.locked");
        this.deleteTopicType("zukunftswerk.viewport");
        this.deleteTopicType("zukunftswerk.editor");
        this.deleteTopicType("zukunftswerk.editor_facet");
        this.deleteTopicType("zukunftswerk.show_email_address");
        this.deleteTopicType("zukunftswerk.show_email_address_facet");
        this.deleteAssocType("zukunftswerk.shared_workspace");
        this.deleteAssocType("zukunftswerk.attachment");
        this.deleteAssocType("zukunftswerk.original_language");
        this.deleteAssocType("zukunftswerk.de");
        this.deleteAssocType("zukunftswerk.fr");
    }

    private void deleteTopicType(String typeUri) {
        this.tx(() -> {
            this.dmx.deleteTopicType(typeUri);
            return null;
        });
    }

    private void deleteAssocType(String typeUri) {
        this.tx(() -> {
            this.dmx.deleteAssocType(typeUri);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T tx(Supplier<T> body) {
        DMXTransaction tx = this.dmx.beginTx();
        try {
            T result = body.get();
            tx.success();
            T t = result;
            return t;
        }
        finally {
            tx.finish();
        }
    }
}

