/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.AssociationDefinitionImpl;
import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.impl.ViewConfigurationModelImpl;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.model.ViewConfigurationModel;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;

class AssociationDefinitionModelImpl
extends AssociationModelImpl
implements AssociationDefinitionModel {
    private String parentCardinalityUri;
    private String childCardinalityUri;
    private ViewConfigurationModelImpl viewConfig;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AssociationDefinitionModelImpl(AssociationModelImpl assoc) {
        this(assoc, null, null, null);
    }

    AssociationDefinitionModelImpl(AssociationModelImpl assoc, String parentCardinalityUri, String childCardinalityUri, ViewConfigurationModelImpl viewConfig) {
        super(assoc);
        this.parentCardinalityUri = parentCardinalityUri;
        this.childCardinalityUri = childCardinalityUri;
        this.viewConfig = viewConfig != null ? viewConfig : this.mf.newViewConfigurationModel();
    }

    @Override
    public String getAssocDefUri() {
        String customAssocTypeUri = this.getCustomAssocTypeUri();
        return this.getChildTypeUri() + (customAssocTypeUri != null ? "#" + customAssocTypeUri : "");
    }

    @Override
    public String getCustomAssocTypeUri() {
        TopicModelImpl customAssocType = this.getCustomAssocType();
        return customAssocType != null ? customAssocType.getUri() : null;
    }

    @Override
    public String getInstanceLevelAssocTypeUri() {
        String customAssocTypeUri = this.getCustomAssocTypeUri();
        return customAssocTypeUri != null ? customAssocTypeUri : this.defaultInstanceLevelAssocTypeUri();
    }

    @Override
    public String getParentTypeUri() {
        return ((TopicRoleModel)((Object)this.getRoleModel("dm4.core.parent_type"))).getTopicUri();
    }

    @Override
    public String getChildTypeUri() {
        return ((TopicRoleModel)((Object)this.getRoleModel("dm4.core.child_type"))).getTopicUri();
    }

    @Override
    public String getParentCardinalityUri() {
        return this.parentCardinalityUri;
    }

    @Override
    public String getChildCardinalityUri() {
        return this.childCardinalityUri;
    }

    @Override
    public ViewConfigurationModelImpl getViewConfigModel() {
        return this.viewConfig;
    }

    @Override
    public void setParentCardinalityUri(String parentCardinalityUri) {
        this.parentCardinalityUri = parentCardinalityUri;
    }

    @Override
    public void setChildCardinalityUri(String childCardinalityUri) {
        this.childCardinalityUri = childCardinalityUri;
    }

    @Override
    public void setViewConfigModel(ViewConfigurationModel viewConfig) {
        this.viewConfig = (ViewConfigurationModelImpl)viewConfig;
    }

    @Override
    public JSONObject toJSON() {
        try {
            return super.toJSON().put("parent_cardinality_uri", (Object)this.parentCardinalityUri).put("child_cardinality_uri", (Object)this.childCardinalityUri).put("view_config_topics", (Object)this.viewConfig.toJSONArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    @Override
    public String toString() {
        return "\n    association definition (" + super.toString() + ",\n        parent cardinality=\"" + this.parentCardinalityUri + "\",\n        child cardinality=\"" + this.childCardinalityUri + "\",\n        " + this.viewConfig + ")\n";
    }

    @Override
    String className() {
        return "association definition";
    }

    @Override
    AssociationDefinitionImpl instantiate() {
        return new AssociationDefinitionImpl(this, this.pl);
    }

    @Override
    AssociationDefinitionModelImpl createModelWithChildTopics(ChildTopicsModel childTopics) {
        return this.mf.newAssociationDefinitionModel(childTopics);
    }

    @Override
    void postUpdate(DeepaMehtaObjectModel updateModel, DeepaMehtaObjectModel oldObject) {
        super.postUpdate(updateModel, oldObject);
        this.updateCardinality((AssociationDefinitionModel)updateModel);
    }

    void updateParentCardinalityUri(String parentCardinalityUri) {
        this.setParentCardinalityUri(parentCardinalityUri);
        this.pl.typeStorage.storeParentCardinalityUri(this.id, parentCardinalityUri);
    }

    void updateChildCardinalityUri(String childCardinalityUri) {
        this.setChildCardinalityUri(childCardinalityUri);
        this.pl.typeStorage.storeChildCardinalityUri(this.id, childCardinalityUri);
    }

    final boolean includeInLabel() {
        RelatedTopicModelImpl includeInLabel = this.getChildTopicsModel().getTopicOrNull("dm4.core.include_in_label");
        if (includeInLabel == null) {
            throw new RuntimeException("Assoc def \"" + this.getAssocDefUri() + "\" has no \"Include in Label\" topic");
        }
        return includeInLabel.getSimpleValue().booleanValue();
    }

    boolean isReadable() {
        try {
            if (!this.pl.hasReadAccess(this)) {
                this.logger.info("### Assoc def \"" + this.getAssocDefUri() + "\" not READable");
                return false;
            }
            TopicModelImpl assocType = this.getCustomAssocType();
            if (assocType != null && !this.pl.hasReadAccess(assocType)) {
                this.logger.info("### Assoc def \"" + this.getAssocDefUri() + "\" not READable (custom assoc type not READable)");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Checking assoc def READability failed (" + this + ")", e);
        }
    }

    private void updateCardinality(AssociationDefinitionModel newAssocDef) {
        this.updateParentCardinality(newAssocDef.getParentCardinalityUri());
        this.updateChildCardinality(newAssocDef.getChildCardinalityUri());
    }

    private void updateParentCardinality(String newParentCardinalityUri) {
        if (newParentCardinalityUri == null) {
            return;
        }
        String parentCardinalityUri = this.getParentCardinalityUri();
        if (!parentCardinalityUri.equals(newParentCardinalityUri)) {
            this.logger.info("### Changing parent cardinality URI from \"" + parentCardinalityUri + "\" -> \"" + newParentCardinalityUri + "\"");
            this.updateParentCardinalityUri(newParentCardinalityUri);
        }
    }

    private void updateChildCardinality(String newChildCardinalityUri) {
        if (newChildCardinalityUri == null) {
            return;
        }
        String childCardinalityUri = this.getChildCardinalityUri();
        if (!childCardinalityUri.equals(newChildCardinalityUri)) {
            this.logger.info("### Changing child cardinality URI from \"" + childCardinalityUri + "\" -> \"" + newChildCardinalityUri + "\"");
            this.updateChildCardinalityUri(newChildCardinalityUri);
        }
    }

    private TopicModelImpl getCustomAssocType() {
        return this.getChildTopicsModel().getTopicOrNull("dm4.core.assoc_type#dm4.core.custom_assoc_type");
    }

    private String defaultInstanceLevelAssocTypeUri() {
        if (this.typeUri.equals("dm4.core.aggregation_def")) {
            return "dm4.core.aggregation";
        }
        if (this.typeUri.equals("dm4.core.composition_def")) {
            return "dm4.core.composition";
        }
        throw new RuntimeException("Unexpected association type URI: \"" + this.typeUri + "\"");
    }
}

