/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.impl.AssociationDefinitionModelImpl;
import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.ChildTopicsModelImpl;
import de.deepamehta.core.impl.EventManager;
import de.deepamehta.core.impl.ModelFactoryImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.impl.TopicReferenceModelImpl;
import de.deepamehta.core.impl.TypeModelImpl;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicDeletionModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicReferenceModel;
import de.deepamehta.core.service.DeepaMehtaEvent;
import de.deepamehta.core.service.Directive;
import de.deepamehta.core.service.Directives;
import de.deepamehta.core.util.JavaUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;

class DeepaMehtaObjectModelImpl
implements DeepaMehtaObjectModel {
    private static final String LABEL_CHILD_SEPARATOR = " ";
    private static final String LABEL_TOPIC_SEPARATOR = ", ";
    long id;
    String uri;
    String typeUri;
    SimpleValue value;
    ChildTopicsModelImpl childTopics;
    PersistenceLayer pl;
    EventManager em;
    ModelFactoryImpl mf;
    Logger logger = Logger.getLogger(this.getClass().getName());

    DeepaMehtaObjectModelImpl(long id, String uri, String typeUri, SimpleValue value, ChildTopicsModelImpl childTopics, PersistenceLayer pl) {
        this.id = id;
        this.uri = uri;
        this.typeUri = typeUri;
        this.value = value;
        this.childTopics = childTopics != null ? childTopics : pl.mf.newChildTopicsModel();
        this.pl = pl;
        this.em = pl.em;
        this.mf = pl.mf;
    }

    DeepaMehtaObjectModelImpl(DeepaMehtaObjectModelImpl object) {
        this(object.getId(), object.getUri(), object.getTypeUri(), object.getSimpleValue(), object.getChildTopicsModel(), object.pl);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public String getTypeUri() {
        return this.typeUri;
    }

    @Override
    public void setTypeUri(String typeUri) {
        this.typeUri = typeUri;
    }

    @Override
    public SimpleValue getSimpleValue() {
        return this.value;
    }

    @Override
    public void setSimpleValue(String value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(int value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(long value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(boolean value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(SimpleValue value) {
        this.value = value;
    }

    @Override
    public ChildTopicsModelImpl getChildTopicsModel() {
        return this.childTopics;
    }

    @Override
    public void setChildTopicsModel(ChildTopicsModel childTopics) {
        this.childTopics = (ChildTopicsModelImpl)childTopics;
    }

    @Override
    public void set(DeepaMehtaObjectModel object) {
        this.setId(object.getId());
        this.setUri(object.getUri());
        this.setTypeUri(object.getTypeUri());
        this.setSimpleValue(object.getSimpleValue());
        this.setChildTopicsModel(object.getChildTopicsModel());
    }

    @Override
    public RoleModel createRoleModel(String roleTypeUri) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public JSONObject toJSON() {
        try {
            this.setDefaults();
            JSONObject o = new JSONObject();
            o.put("id", this.id);
            o.put("uri", (Object)this.uri);
            o.put("type_uri", (Object)this.typeUri);
            o.put("value", this.value.value());
            o.put("childs", (Object)this.childTopics.toJSON());
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    @Override
    public DeepaMehtaObjectModel clone() {
        try {
            DeepaMehtaObjectModel object = (DeepaMehtaObjectModel)super.clone();
            object.setChildTopicsModel(this.childTopics.clone());
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a DeepaMehtaObjectModel failed", e);
        }
    }

    public boolean equals(Object o) {
        return ((DeepaMehtaObjectModel)o).getId() == this.id;
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }

    public String toString() {
        return "id=" + this.id + ", uri=\"" + this.uri + "\", typeUri=\"" + this.typeUri + "\", value=\"" + this.value + "\", childTopics=" + this.childTopics;
    }

    String className() {
        throw new UnsupportedOperationException();
    }

    DeepaMehtaObject instantiate() {
        throw new UnsupportedOperationException();
    }

    DeepaMehtaObjectModelImpl createModelWithChildTopics(ChildTopicsModel childTopics) {
        throw new UnsupportedOperationException();
    }

    TypeModelImpl getType() {
        throw new UnsupportedOperationException();
    }

    List<AssociationModelImpl> getAssociations() {
        throw new UnsupportedOperationException();
    }

    RelatedTopicModelImpl getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        throw new UnsupportedOperationException();
    }

    List<RelatedTopicModelImpl> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        throw new UnsupportedOperationException();
    }

    List<RelatedTopicModelImpl> getRelatedTopics(List assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        throw new UnsupportedOperationException();
    }

    void storeUri() {
        throw new UnsupportedOperationException();
    }

    void storeTypeUri() {
        throw new UnsupportedOperationException();
    }

    void storeSimpleValue() {
        throw new UnsupportedOperationException();
    }

    void indexSimpleValue(IndexMode indexMode) {
        throw new UnsupportedOperationException();
    }

    void storeProperty(String propUri, Object propValue, boolean addToIndex) {
        throw new UnsupportedOperationException();
    }

    void removeProperty(String propUri) {
        throw new UnsupportedOperationException();
    }

    void _delete() {
        throw new UnsupportedOperationException();
    }

    void checkReadAccess() {
        throw new UnsupportedOperationException();
    }

    DeepaMehtaEvent getPreUpdateEvent() {
        throw new UnsupportedOperationException();
    }

    DeepaMehtaEvent getPostUpdateEvent() {
        throw new UnsupportedOperationException();
    }

    DeepaMehtaEvent getPreDeleteEvent() {
        throw new UnsupportedOperationException();
    }

    DeepaMehtaEvent getPostDeleteEvent() {
        throw new UnsupportedOperationException();
    }

    Directive getUpdateDirective() {
        throw new UnsupportedOperationException();
    }

    Directive getDeleteDirective() {
        throw new UnsupportedOperationException();
    }

    void preCreate() {
    }

    void postCreate() {
    }

    void preUpdate(DeepaMehtaObjectModel updateModel) {
    }

    void postUpdate(DeepaMehtaObjectModel updateModel, DeepaMehtaObjectModel oldObject) {
    }

    void preDelete() {
    }

    void postDelete() {
    }

    final void updateWithChildTopics(ChildTopicsModel childTopics) {
        this.update(this.createModelWithChildTopics(childTopics));
    }

    final void update(DeepaMehtaObjectModelImpl updateModel) {
        try {
            this.logger.info("Updating " + this.objectInfo() + " (typeUri=\"" + this.typeUri + "\")");
            DeepaMehtaObjectModel oldObject = this.clone();
            this.em.fireEvent(this.getPreUpdateEvent(), this.instantiate(), updateModel);
            this.preUpdate(updateModel);
            this._updateUri(updateModel.getUri());
            this._updateTypeUri(updateModel.getTypeUri());
            if (this.isSimple()) {
                this._updateSimpleValue(updateModel.getSimpleValue());
            } else {
                this._updateChildTopics(updateModel.getChildTopicsModel());
            }
            this.postUpdate(updateModel, oldObject);
            DeepaMehtaObject object = this.instantiate();
            Directives.get().add(this.getUpdateDirective(), object);
            this.em.fireEvent(this.getPostUpdateEvent(), object, updateModel, oldObject);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating " + this.objectInfo() + " failed (typeUri=\"" + this.typeUri + "\")", e);
        }
    }

    final void updateUri(String uri) {
        this.setUri(uri);
        this.storeUri();
    }

    final void updateTypeUri(String typeUri) {
        this.setTypeUri(typeUri);
        this.storeTypeUri();
    }

    final void updateSimpleValue(SimpleValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Tried to set a null SimpleValue (" + this + ")");
        }
        this.setSimpleValue(value);
        this.storeSimpleValue();
    }

    final void delete() {
        try {
            this.em.fireEvent(this.getPreDeleteEvent(), this.instantiate());
            this.preDelete();
            for (AssociationDefinitionModel associationDefinitionModel : this.getType().getAssocDefs()) {
                if (!associationDefinitionModel.getTypeUri().equals("dm4.core.composition_def")) continue;
                for (TopicModelImpl topicModelImpl : this.getRelatedTopics(associationDefinitionModel.getInstanceLevelAssocTypeUri(), "dm4.core.parent", "dm4.core.child", associationDefinitionModel.getChildTypeUri())) {
                    topicModelImpl.delete();
                }
            }
            for (AssociationModelImpl associationModelImpl : this.getAssociations()) {
                associationModelImpl.delete();
            }
            this.logger.info("Deleting " + this.objectInfo() + " (typeUri=\"" + this.typeUri + "\")");
            this._delete();
            this.postDelete();
            Directives.get().add(this.getDeleteDirective(), this);
            this.em.fireEvent(this.getPostDeleteEvent(), this);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().equals("Node[" + this.id + "] has been deleted in this tx")) {
                this.logger.info("### Association " + this.id + " has already been deleted in this transaction. This can happen while deleting a topic with associations A1 and A2 while A2 points to A1 (" + this + ")");
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting " + this.objectInfo() + " failed (typeUri=\"" + this.typeUri + "\")", e);
        }
    }

    final void _updateChildTopics(ChildTopicsModelImpl updateModel) {
        try {
            for (AssociationDefinitionModel associationDefinitionModel : this.getType().getAssocDefs()) {
                String assocDefUri = associationDefinitionModel.getAssocDefUri();
                String cardinalityUri = associationDefinitionModel.getChildCardinalityUri();
                RelatedTopicModelImpl newChildTopic = null;
                List<RelatedTopicModelImpl> newChildTopics = null;
                if (cardinalityUri.equals("dm4.core.one")) {
                    newChildTopic = updateModel.getTopicOrNull(assocDefUri);
                    if (newChildTopic == null) {
                        continue;
                    }
                } else if (cardinalityUri.equals("dm4.core.many")) {
                    newChildTopics = updateModel.getTopicsOrNull(assocDefUri);
                    if (newChildTopics == null) {
                        continue;
                    }
                } else {
                    throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
                }
                this.updateChildTopics(newChildTopic, newChildTopics, associationDefinitionModel);
            }
            this._calculateLabelAndUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("Updating the child topics of " + this.objectInfo() + " failed", e);
        }
    }

    final void updateChildTopics(RelatedTopicModelImpl newChildTopic, List<RelatedTopicModelImpl> newChildTopics, AssociationDefinitionModel assocDef) {
        boolean one;
        this.loadChildTopics(assocDef);
        String assocTypeUri = assocDef.getTypeUri();
        boolean bl = one = newChildTopic != null;
        if (assocTypeUri.equals("dm4.core.composition_def")) {
            if (one) {
                this.updateCompositionOne(newChildTopic, assocDef);
            } else {
                this.updateCompositionMany(newChildTopics, assocDef);
            }
        } else if (assocTypeUri.equals("dm4.core.aggregation_def")) {
            if (one) {
                this.updateAggregationOne(newChildTopic, assocDef);
            } else {
                this.updateAggregationMany(newChildTopics, assocDef);
            }
        } else {
            throw new RuntimeException("Association type \"" + assocTypeUri + "\" not supported");
        }
    }

    final DeepaMehtaObjectModel loadChildTopics() {
        for (AssociationDefinitionModel associationDefinitionModel : this.getType().getAssocDefs()) {
            this.loadChildTopics(associationDefinitionModel);
        }
        return this;
    }

    final DeepaMehtaObjectModel loadChildTopics(String assocDefUri) {
        try {
            return this.loadChildTopics(this.getAssocDef(assocDefUri));
        }
        catch (Exception e) {
            throw new RuntimeException("Loading \"" + assocDefUri + "\" child topics of " + this.objectInfo() + " failed", e);
        }
    }

    SimpleValue getIndexValue() {
        SimpleValue value = this.getSimpleValue();
        if (this.getType().getDataTypeUri().equals("dm4.core.html")) {
            return new SimpleValue(JavaUtils.stripHTML(value.toString()));
        }
        return value;
    }

    boolean uriChange(String newUri, String compareUri) {
        return newUri != null && !newUri.equals(compareUri);
    }

    boolean isSimple() {
        return !this.getType().getDataTypeUri().equals("dm4.core.composite");
    }

    private void setDefaults() {
        if (this.getUri() == null) {
            this.setUri("");
        }
        if (this.getSimpleValue() == null) {
            this.setSimpleValue("");
        }
    }

    private DeepaMehtaObjectModel loadChildTopics(AssociationDefinitionModel assocDef) {
        String assocDefUri = assocDef.getAssocDefUri();
        if (!this.childTopics.has(assocDefUri)) {
            this.logger.fine("### Lazy-loading \"" + assocDefUri + "\" child topic(s) of " + this.objectInfo());
            this.pl.valueStorage.fetchChildTopics(this, assocDef);
        }
        return this;
    }

    private void _updateUri(String newUri) {
        if (this.uriChange(newUri, this.uri)) {
            this.logger.info("### Changing URI of " + this.objectInfo() + " from \"" + this.uri + "\" -> \"" + newUri + "\"");
            this.updateUri(newUri);
        }
    }

    private void _updateTypeUri(String newTypeUri) {
        if (newTypeUri != null && !newTypeUri.equals(this.typeUri)) {
            this.logger.info("### Changing type URI of " + this.objectInfo() + " from \"" + this.typeUri + "\" -> \"" + newTypeUri + "\"");
            this.updateTypeUri(newTypeUri);
        }
    }

    private void _updateSimpleValue(SimpleValue newValue) {
        if (newValue != null && !newValue.equals(this.value)) {
            this.logger.info("### Changing simple value of " + this.objectInfo() + " from \"" + this.value + "\" -> \"" + newValue + "\"");
            this.updateSimpleValue(newValue);
        }
    }

    private void updateCompositionOne(RelatedTopicModelImpl newChildTopic, AssociationDefinitionModel assocDef) {
        RelatedTopicModelImpl childTopic = this.childTopics.getTopicOrNull(assocDef.getAssocDefUri());
        if (newChildTopic instanceof TopicDeletionModel) {
            this.deleteChildTopicOne(childTopic, assocDef, true);
        } else if (newChildTopic instanceof TopicReferenceModel) {
            this.createAssignmentOne(childTopic, (TopicReferenceModelImpl)newChildTopic, assocDef, true);
        } else if (childTopic != null) {
            this.updateRelatedTopic(childTopic, newChildTopic);
        } else {
            this.createChildTopicOne(newChildTopic, assocDef);
        }
    }

    private void updateCompositionMany(List<RelatedTopicModelImpl> newChildTopics, AssociationDefinitionModel assocDef) {
        for (RelatedTopicModelImpl newChildTopic : newChildTopics) {
            long childTopicId = newChildTopic.getId();
            if (newChildTopic instanceof TopicDeletionModel) {
                this.deleteChildTopicMany(childTopicId, assocDef, true);
                continue;
            }
            if (newChildTopic instanceof TopicReferenceModel) {
                this.createAssignmentMany((TopicReferenceModelImpl)newChildTopic, assocDef);
                continue;
            }
            if (childTopicId != -1L) {
                this.updateChildTopicMany(newChildTopic, assocDef);
                continue;
            }
            this.createChildTopicMany(newChildTopic, assocDef);
        }
    }

    private void updateAggregationOne(RelatedTopicModelImpl newChildTopic, AssociationDefinitionModel assocDef) {
        RelatedTopicModelImpl childTopic = this.childTopics.getTopicOrNull(assocDef.getAssocDefUri());
        if (newChildTopic instanceof TopicDeletionModel) {
            this.deleteChildTopicOne(childTopic, assocDef, false);
        } else if (newChildTopic instanceof TopicReferenceModel) {
            this.createAssignmentOne(childTopic, (TopicReferenceModelImpl)newChildTopic, assocDef, false);
        } else if (newChildTopic.getId() != -1L) {
            this.updateChildTopicOne(newChildTopic, assocDef);
        } else {
            if (childTopic != null) {
                childTopic.getRelatingAssociation().delete();
            }
            this.createChildTopicOne(newChildTopic, assocDef);
        }
    }

    private void updateAggregationMany(List<RelatedTopicModelImpl> newChildTopics, AssociationDefinitionModel assocDef) {
        for (RelatedTopicModelImpl newChildTopic : newChildTopics) {
            long childTopicId = newChildTopic.getId();
            if (newChildTopic instanceof TopicDeletionModel) {
                this.deleteChildTopicMany(childTopicId, assocDef, false);
                continue;
            }
            if (newChildTopic instanceof TopicReferenceModel) {
                this.createAssignmentMany((TopicReferenceModelImpl)newChildTopic, assocDef);
                continue;
            }
            if (childTopicId != -1L) {
                this.updateChildTopicMany(newChildTopic, assocDef);
                continue;
            }
            this.createChildTopicMany(newChildTopic, assocDef);
        }
    }

    private void updateChildTopicOne(RelatedTopicModelImpl newChildTopic, AssociationDefinitionModel assocDef) {
        RelatedTopicModelImpl childTopic = this.childTopics.getTopicOrNull(assocDef.getAssocDefUri());
        if (childTopic == null || childTopic.getId() != newChildTopic.getId()) {
            throw new RuntimeException("Topic " + newChildTopic.getId() + " is not a child of " + this.objectInfo() + " according to " + assocDef);
        }
        this.updateRelatedTopic(childTopic, newChildTopic);
    }

    private void updateChildTopicMany(RelatedTopicModelImpl newChildTopic, AssociationDefinitionModel assocDef) {
        RelatedTopicModelImpl childTopic = this.childTopics.findChildTopicById(newChildTopic.getId(), assocDef);
        if (childTopic == null) {
            throw new RuntimeException("Topic " + newChildTopic.getId() + " is not a child of " + this.objectInfo() + " according to " + assocDef);
        }
        this.updateRelatedTopic(childTopic, newChildTopic);
    }

    private void updateRelatedTopic(RelatedTopicModelImpl childTopic, RelatedTopicModelImpl newChildTopic) {
        childTopic.update(newChildTopic);
        this.updateRelatingAssociation(childTopic, newChildTopic);
    }

    private void updateRelatingAssociation(RelatedTopicModelImpl childTopic, RelatedTopicModelImpl newChildTopic) {
        childTopic.getRelatingAssociation().update(newChildTopic.getRelatingAssociation());
    }

    private void createChildTopicOne(RelatedTopicModelImpl newChildTopic, AssociationDefinitionModel assocDef) {
        this.createAndAssociateChildTopic(newChildTopic, assocDef);
        this.childTopics.putInChildTopics(newChildTopic, assocDef);
    }

    private void createChildTopicMany(RelatedTopicModelImpl newChildTopic, AssociationDefinitionModel assocDef) {
        this.createAndAssociateChildTopic(newChildTopic, assocDef);
        this.childTopics.addToChildTopics(newChildTopic, assocDef);
    }

    private void createAndAssociateChildTopic(RelatedTopicModelImpl childTopic, AssociationDefinitionModel assocDef) {
        this.pl.createTopic(childTopic);
        this.associateChildTopic(childTopic, assocDef);
    }

    private void createAssignmentOne(RelatedTopicModelImpl childTopic, TopicReferenceModelImpl newChildTopic, AssociationDefinitionModel assocDef, boolean deleteChildTopic) {
        if (childTopic != null) {
            if (newChildTopic.isReferingTo(childTopic)) {
                this.updateRelatingAssociation(childTopic, newChildTopic);
                return;
            }
            if (deleteChildTopic) {
                childTopic.delete();
            } else {
                childTopic.getRelatingAssociation().delete();
            }
        }
        this.resolveRefAndAssociateChildTopic(newChildTopic, assocDef);
        this.childTopics.putInChildTopics(newChildTopic, assocDef);
    }

    private void createAssignmentMany(TopicReferenceModelImpl newChildTopic, AssociationDefinitionModel assocDef) {
        RelatedTopicModelImpl childTopic = this.childTopics.findChildTopicByRef(newChildTopic, assocDef);
        if (childTopic != null) {
            this.updateRelatingAssociation(childTopic, newChildTopic);
            return;
        }
        this.resolveRefAndAssociateChildTopic(newChildTopic, assocDef);
        this.childTopics.addToChildTopics(newChildTopic, assocDef);
    }

    private void resolveRefAndAssociateChildTopic(TopicReferenceModel childTopicRef, AssociationDefinitionModel assocDef) {
        this.pl.valueStorage.resolveReference(childTopicRef);
        this.associateChildTopic(childTopicRef, assocDef);
    }

    private void associateChildTopic(RelatedTopicModel childTopic, AssociationDefinitionModel assocDef) {
        this.pl.valueStorage.associateChildTopic(this, childTopic, assocDef);
    }

    private void deleteChildTopicOne(RelatedTopicModelImpl childTopic, AssociationDefinitionModel assocDef, boolean deleteChildTopic) {
        if (childTopic == null) {
            return;
        }
        if (deleteChildTopic) {
            childTopic.delete();
        } else {
            childTopic.getRelatingAssociation().delete();
        }
        this.childTopics.removeChildTopic(assocDef);
    }

    private void deleteChildTopicMany(long childTopicId, AssociationDefinitionModel assocDef, boolean deleteChildTopic) {
        RelatedTopicModelImpl childTopic = this.childTopics.findChildTopicById(childTopicId, assocDef);
        if (childTopic == null) {
            return;
        }
        if (deleteChildTopic) {
            childTopic.delete();
        } else {
            childTopic.getRelatingAssociation().delete();
        }
        this.childTopics.removeFromChildTopics(childTopic, assocDef);
    }

    private void _calculateLabelAndUpdate() {
        List<String> labelAssocDefUris = null;
        try {
            labelAssocDefUris = this.getLabelAssocDefUris();
            for (String assocDefUri : labelAssocDefUris) {
                this.loadChildTopics(assocDefUri);
            }
            this.calculateLabelAndUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("Calculating and updating label of " + this.objectInfo() + " failed (assoc defs involved: " + labelAssocDefUris + ")", e);
        }
    }

    void calculateLabelAndUpdate() {
        try {
            this.updateSimpleValue(new SimpleValue(this.calculateLabel()));
        }
        catch (Exception e) {
            throw new RuntimeException("Calculating and updating label of " + this.objectInfo() + " failed", e);
        }
    }

    String calculateLabel() {
        TypeModelImpl type = this.getType();
        if (type.getDataTypeUri().equals("dm4.core.composite")) {
            StringBuilder builder = new StringBuilder();
            for (String assocDefUri : this.getLabelAssocDefUris()) {
                this.appendLabel(this.calculateChildLabel(assocDefUri), builder, LABEL_CHILD_SEPARATOR);
            }
            return builder.toString();
        }
        return this.getSimpleValue().toString();
    }

    private String calculateChildLabel(String assocDefUri) {
        Object value = this.getChildTopicsModel().get(assocDefUri);
        if (value == null) {
            return "";
        }
        if (value instanceof TopicModel) {
            return ((TopicModelImpl)value).calculateLabel();
        }
        if (value instanceof List) {
            StringBuilder builder = new StringBuilder();
            for (TopicModelImpl childTopic : (List)value) {
                this.appendLabel(childTopic.calculateLabel(), builder, LABEL_TOPIC_SEPARATOR);
            }
            return builder.toString();
        }
        throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
    }

    private void appendLabel(String label, StringBuilder builder, String separator) {
        if (builder.length() > 0 && label.length() > 0) {
            builder.append(separator);
        }
        builder.append(label);
    }

    private List<String> getLabelAssocDefUris() {
        TypeModelImpl type = this.getType();
        List<String> labelConfig = type.getLabelConfig();
        if (labelConfig.size() > 0) {
            return labelConfig;
        }
        ArrayList<String> assocDefUris = new ArrayList<String>();
        Iterator<AssociationDefinitionModelImpl> i = type.getAssocDefs().iterator();
        if (i.hasNext()) {
            assocDefUris.add(((AssociationDefinitionModel)i.next()).getAssocDefUri());
        }
        return assocDefUris;
    }

    private AssociationDefinitionModel getAssocDef(String assocDefUri) {
        return this.getType().getAssocDef(assocDefUri);
    }

    private String objectInfo() {
        return this.className() + LABEL_CHILD_SEPARATOR + this.id;
    }
}

