/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicReferenceModel;
import java.util.List;

class TopicReferenceModelImpl
extends RelatedTopicModelImpl
implements TopicReferenceModel {
    TopicReferenceModelImpl(RelatedTopicModelImpl relatedTopic) {
        super(relatedTopic);
    }

    @Override
    public boolean isReferenceById() {
        return this.getId() != -1L;
    }

    @Override
    public boolean isReferenceByUri() {
        return this.getUri() != null && !this.getUri().equals("");
    }

    @Override
    public boolean isReferingTo(TopicModel topic) {
        if (this.isReferenceById()) {
            return this.getId() == topic.getId();
        }
        if (this.isReferenceByUri()) {
            return this.getUri().equals(topic.getUri());
        }
        throw new RuntimeException("Invalid topic reference (" + this + ")");
    }

    @Override
    public RelatedTopicModelImpl findReferencedTopic(List<? extends RelatedTopicModel> topics) {
        for (RelatedTopicModel relatedTopicModel : topics) {
            if (!this.isReferingTo(relatedTopicModel)) continue;
            return (RelatedTopicModelImpl)relatedTopicModel;
        }
        return null;
    }

    @Override
    public String toString() {
        return "reference " + super.toString();
    }
}

