/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Topic;
import de.deepamehta.core.ViewConfiguration;
import de.deepamehta.core.impl.ModelFactoryImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.impl.ViewConfigurationModelImpl;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.ViewConfigurationModel;

class ViewConfigurationImpl
implements ViewConfiguration {
    private ViewConfigurationModelImpl model;
    private RoleModel configurable;
    private PersistenceLayer pl;
    private ModelFactoryImpl mf;

    ViewConfigurationImpl(RoleModel configurable, ViewConfigurationModelImpl model, PersistenceLayer pl) {
        this.configurable = configurable;
        this.model = model;
        this.pl = pl;
        this.mf = pl.mf;
    }

    @Override
    public Iterable<Topic> getConfigTopics() {
        return this.pl.instantiate(this.model.getConfigTopics());
    }

    @Override
    public Topic getConfigTopic(String configTypeUri) {
        TopicModelImpl configTopic = this.model.getConfigTopic(configTypeUri);
        return configTopic != null ? configTopic.instantiate() : null;
    }

    @Override
    public Topic addConfigTopic(TopicModel configTopic) {
        TopicModelImpl _configTopic = (TopicModelImpl)configTopic;
        this._addConfigTopic(_configTopic);
        return _configTopic.instantiate();
    }

    @Override
    public void setConfigValue(String configTypeUri, String childTypeUri, Object value) {
        ChildTopicsModel childs = this.mf.newChildTopicsModel().put(childTypeUri, value);
        TopicModelImpl configTopic = this.model.getConfigTopic(configTypeUri);
        if (configTopic == null) {
            configTopic = this.mf.newTopicModel(configTypeUri, childs);
            this._addConfigTopic(configTopic);
        } else {
            configTopic.updateWithChildTopics(childs);
        }
    }

    @Override
    public ViewConfigurationModel getModel() {
        return this.model;
    }

    public void _addConfigTopic(TopicModelImpl configTopic) {
        this.model.addConfigTopic(configTopic);
        this.pl.typeStorage.storeViewConfigTopic(this.configurable, configTopic);
    }
}

