/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.storage.neo4j;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;

class RelationtypeCache {
    private final Map<String, RelationshipType> relTypeCache;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    RelationtypeCache(GraphDatabaseService neo4j) {
        this.relTypeCache = this.createRelTypeCache(neo4j);
    }

    RelationshipType get(String typeName) {
        RelationshipType relType = this.relTypeCache.get(typeName);
        if (relType == null) {
            this.logger.fine("Creating Neo4j relationship type \"" + typeName + "\" dynamically");
            relType = DynamicRelationshipType.withName((String)typeName);
            this.relTypeCache.put(typeName, relType);
        }
        return relType;
    }

    private Map<String, RelationshipType> createRelTypeCache(GraphDatabaseService neo4j) {
        HashMap<String, RelationshipType> relTypeCache = new HashMap<String, RelationshipType>();
        for (RelationshipType relType : neo4j.getRelationshipTypes()) {
            relTypeCache.put(relType.name(), relType);
        }
        return relTypeCache;
    }
}

