/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.boxrenderer.dom;

import de.deepamehta.core.Association;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.model.topicmaps.ViewProperties;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.Inject;
import de.deepamehta.topicmaps.TopicmapsService;
import de.deepamehta.topicmaps.ViewmodelCustomizer;
import java.util.logging.Logger;

public class BoxRendererPlugin
extends PluginActivator
implements ViewmodelCustomizer {
    private static final String PROP_COLOR = "dm4.boxrenderer.color";
    private static final String PROP_EXPANDED = "dm4.boxrenderer.expanded";
    @Inject
    private TopicmapsService topicmapsService;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void serviceArrived(Object service) {
        ((TopicmapsService)service).registerViewmodelCustomizer((ViewmodelCustomizer)this);
    }

    public void serviceGone(Object service) {
        ((TopicmapsService)service).unregisterViewmodelCustomizer((ViewmodelCustomizer)this);
    }

    public void enrichViewProperties(RelatedTopic topic, ViewProperties viewProps) {
        boolean expanded = this._enrichViewProperties(topic, viewProps);
        if (expanded) {
            topic.loadChildTopics("dm4.notes.text");
        }
    }

    private boolean _enrichViewProperties(RelatedTopic topic, ViewProperties viewProps) {
        Association mapcontextAssoc = topic.getRelatingAssociation();
        if (mapcontextAssoc.hasProperty(PROP_COLOR)) {
            String color = (String)mapcontextAssoc.getProperty(PROP_COLOR);
            viewProps.put(PROP_COLOR, (Object)color);
        }
        boolean expanded = false;
        if (topic.getTypeUri().equals("dm4.notes.note") && mapcontextAssoc.hasProperty(PROP_EXPANDED)) {
            expanded = (Boolean)mapcontextAssoc.getProperty(PROP_EXPANDED);
            viewProps.put(PROP_EXPANDED, (Object)expanded);
        }
        return expanded;
    }
}

