/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model.topicmaps;

import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.util.DeepaMehtaUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;

public class ViewProperties
implements Iterable<String>,
JSONEnabled {
    private Map<String, Object> viewProps = new HashMap<String, Object>();

    public ViewProperties(JSONObject viewProps) {
        DeepaMehtaUtils.toMap(viewProps, this.viewProps);
    }

    public ViewProperties(int x, int y, boolean visibility) {
        this.initPos(x, y);
        this.initVisibility(visibility);
    }

    public ViewProperties(int x, int y) {
        this.initPos(x, y);
    }

    public ViewProperties(boolean visibility) {
        this.initVisibility(visibility);
    }

    public Object get(String propUri) {
        return this.viewProps.get(propUri);
    }

    public void put(String propUri, Object value) {
        this.viewProps.put(propUri, value);
    }

    public int getInt(String propUri) {
        return (Integer)this.get(propUri);
    }

    public boolean getBoolean(String propUri) {
        return (Boolean)this.get(propUri);
    }

    @Override
    public Iterator<String> iterator() {
        return this.viewProps.keySet().iterator();
    }

    @Override
    public JSONObject toJSON() {
        return new JSONObject(this.viewProps);
    }

    private void initPos(int x, int y) {
        this.put("dm4.topicmaps.x", x);
        this.put("dm4.topicmaps.y", y);
    }

    private void initVisibility(boolean visibility) {
        this.put("dm4.topicmaps.visibility", visibility);
    }
}

