/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.util;

import java.util.concurrent.Callable;

public class ContextTracker {
    private ThreadLocal<Integer> trackingLevel = new ThreadLocal(){

        protected Integer initialValue() {
            return 0;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V run(Callable<V> callable) throws Exception {
        int level = this.trackingLevel.get();
        try {
            this.trackingLevel.set(level + 1);
            V v = callable.call();
            return v;
        }
        finally {
            this.trackingLevel.set(level);
        }
    }

    public boolean runsInTrackedContext() {
        return this.trackingLevel.get() > 0;
    }
}

