/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.workspaces;

import de.deepamehta.config.ConfigDefinition;
import de.deepamehta.config.ConfigModificationRole;
import de.deepamehta.config.ConfigService;
import de.deepamehta.config.ConfigTarget;
import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.DeepaMehtaType;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.Cookies;
import de.deepamehta.core.service.DirectivesResponse;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.Transactional;
import de.deepamehta.core.service.accesscontrol.SharingMode;
import de.deepamehta.core.service.event.IntroduceAssociationTypeListener;
import de.deepamehta.core.service.event.IntroduceTopicTypeListener;
import de.deepamehta.core.service.event.PostCreateAssociationListener;
import de.deepamehta.core.service.event.PostCreateTopicListener;
import de.deepamehta.core.service.event.PreDeleteTopicListener;
import de.deepamehta.facets.FacetsService;
import de.deepamehta.topicmaps.TopicmapsService;
import de.deepamehta.workspaces.WorkspacesService;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/workspace")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WorkspacesPlugin
extends PluginActivator
implements WorkspacesService,
IntroduceTopicTypeListener,
IntroduceAssociationTypeListener,
PostCreateTopicListener,
PostCreateAssociationListener,
PreDeleteTopicListener {
    private static final boolean SHARING_MODE_PRIVATE_ENABLED = Boolean.parseBoolean(System.getProperty("dm4.workspaces.private.enabled", "true"));
    private static final boolean SHARING_MODE_CONFIDENTIAL_ENABLED = Boolean.parseBoolean(System.getProperty("dm4.workspaces.confidential.enabled", "true"));
    private static final boolean SHARING_MODE_COLLABORATIVE_ENABLED = Boolean.parseBoolean(System.getProperty("dm4.workspaces.collaborative.enabled", "true"));
    private static final boolean SHARING_MODE_PUBLIC_ENABLED = Boolean.parseBoolean(System.getProperty("dm4.workspaces.public.enabled", "true"));
    private static final boolean SHARING_MODE_COMMON_ENABLED = Boolean.parseBoolean(System.getProperty("dm4.workspaces.common.enabled", "true"));
    @Inject
    private FacetsService facetsService;
    @Inject
    private TopicmapsService topicmapsService;
    @Inject
    private ConfigService configService;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @POST
    @Path(value="/{name}/{uri:[^/]*?}/{sharing_mode_uri}")
    @Transactional
    public Topic createWorkspace(final @PathParam(value="name") String name, final @PathParam(value="uri") String uri, final @PathParam(value="sharing_mode_uri") SharingMode sharingMode) {
        final String operation = "Creating workspace \"" + name + "\" ";
        final String info = "(uri=\"" + uri + "\", sharingMode=" + sharingMode + ")";
        try {
            return (Topic)this.dm4.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    WorkspacesPlugin.this.logger.info(operation + info);
                    Topic workspace = WorkspacesPlugin.this.dm4.createTopic(WorkspacesPlugin.this.mf.newTopicModel(uri, "dm4.workspaces.workspace", WorkspacesPlugin.this.mf.newChildTopicsModel().put("dm4.workspaces.name", (Object)name).putRef("dm4.workspaces.sharing_mode", sharingMode.getUri())));
                    Topic topicmap = WorkspacesPlugin.this.topicmapsService.createTopicmap("untitled", "dm4.webclient.default_topicmap_renderer", false);
                    WorkspacesPlugin.this.dm4.getAccessControl().assignToWorkspace((DeepaMehtaObject)topicmap, workspace.getId());
                    return workspace;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(operation + "failed " + info, e);
        }
    }

    @Override
    @GET
    @Path(value="/{uri}")
    public Topic getWorkspace(@PathParam(value="uri") String uri) {
        return this.dm4.getAccessControl().getWorkspace(uri);
    }

    @Override
    @GET
    @Path(value="/object/{id}")
    public Topic getAssignedWorkspace(@PathParam(value="id") long objectId) {
        long workspaceId = this.getAssignedWorkspaceId(objectId);
        if (workspaceId == -1L) {
            return null;
        }
        return this.dm4.getTopic(workspaceId);
    }

    @PUT
    @Path(value="/{workspace_id}/object/{object_id}")
    @Transactional
    public DirectivesResponse assignToWorkspace(@PathParam(value="object_id") long objectId, @PathParam(value="workspace_id") long workspaceId) {
        try {
            this.checkWorkspaceId(workspaceId);
            this._assignToWorkspace(this.dm4.getObject(objectId), workspaceId);
            return new DirectivesResponse();
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning object " + objectId + " to workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public void assignToWorkspace(DeepaMehtaObject object, long workspaceId) {
        try {
            this.checkWorkspaceId(workspaceId);
            this._assignToWorkspace(object, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning " + this.info(object) + " to workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public void assignTypeToWorkspace(DeepaMehtaType type, long workspaceId) {
        try {
            this.checkWorkspaceId(workspaceId);
            this._assignToWorkspace((DeepaMehtaObject)type, workspaceId);
            for (Topic configTopic : type.getViewConfig().getConfigTopics()) {
                this._assignToWorkspace((DeepaMehtaObject)configTopic, workspaceId);
            }
            for (AssociationDefinition assocDef : type.getAssocDefs()) {
                this._assignToWorkspace((DeepaMehtaObject)assocDef, workspaceId);
                for (Topic configTopic : assocDef.getViewConfig().getConfigTopics()) {
                    this._assignToWorkspace((DeepaMehtaObject)configTopic, workspaceId);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning " + this.info((DeepaMehtaObject)type) + " to workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/{id}/topics")
    public List<Topic> getAssignedTopics(@PathParam(value="id") long workspaceId) {
        return this.dm4.getTopicsByProperty("dm4.workspaces.workspace_id", (Object)workspaceId);
    }

    @Override
    @GET
    @Path(value="/{id}/assocs")
    public List<Association> getAssignedAssociations(@PathParam(value="id") long workspaceId) {
        return this.dm4.getAssociationsByProperty("dm4.workspaces.workspace_id", (Object)workspaceId);
    }

    @Override
    @GET
    @Path(value="/{id}/topics/{topic_type_uri}")
    public List<Topic> getAssignedTopics(@PathParam(value="id") long workspaceId, @PathParam(value="topic_type_uri") String topicTypeUri) {
        List topics = this.dm4.getTopicsByType(topicTypeUri);
        this.applyWorkspaceFilter(topics.iterator(), workspaceId);
        return topics;
    }

    @Override
    @GET
    @Path(value="/{id}/assocs/{assoc_type_uri}")
    public List<Association> getAssignedAssociations(@PathParam(value="id") long workspaceId, @PathParam(value="assoc_type_uri") String assocTypeUri) {
        List assocs = this.dm4.getAssociationsByType(assocTypeUri);
        this.applyWorkspaceFilter(assocs.iterator(), workspaceId);
        return assocs;
    }

    public void preInstall() {
        this.configService.registerConfigDefinition(new ConfigDefinition(ConfigTarget.TYPE_INSTANCES, "dm4.accesscontrol.username", this.mf.newTopicModel("dm4.workspaces.enabled_sharing_modes", this.mf.newChildTopicsModel().put("dm4.workspaces.private.enabled", (Object)SHARING_MODE_PRIVATE_ENABLED).put("dm4.workspaces.confidential.enabled", (Object)SHARING_MODE_CONFIDENTIAL_ENABLED).put("dm4.workspaces.collaborative.enabled", (Object)SHARING_MODE_COLLABORATIVE_ENABLED).put("dm4.workspaces.public.enabled", (Object)SHARING_MODE_PUBLIC_ENABLED).put("dm4.workspaces.common.enabled", (Object)SHARING_MODE_COMMON_ENABLED)), ConfigModificationRole.ADMIN));
    }

    public void shutdown() {
        if (this.configService != null) {
            this.configService.unregisterConfigDefinition("dm4.workspaces.enabled_sharing_modes");
        } else {
            this.logger.warning("Config service is already gone");
        }
    }

    public void introduceTopicType(TopicType topicType) {
        long workspaceId = this.workspaceIdForType((DeepaMehtaType)topicType);
        if (workspaceId == -1L) {
            return;
        }
        this.assignTypeToWorkspace((DeepaMehtaType)topicType, workspaceId);
    }

    public void introduceAssociationType(AssociationType assocType) {
        long workspaceId = this.workspaceIdForType((DeepaMehtaType)assocType);
        if (workspaceId == -1L) {
            return;
        }
        this.assignTypeToWorkspace((DeepaMehtaType)assocType, workspaceId);
    }

    public void postCreateTopic(Topic topic) {
        if (this.workspaceAssignmentIsSuppressed((DeepaMehtaObject)topic)) {
            return;
        }
        if (this.isWorkspaceDescription(topic)) {
            return;
        }
        long workspaceId = this.workspaceId();
        if (workspaceId == -1L) {
            return;
        }
        this.assignToWorkspace((DeepaMehtaObject)topic, workspaceId);
    }

    public void postCreateAssociation(Association assoc) {
        if (this.workspaceAssignmentIsSuppressed((DeepaMehtaObject)assoc)) {
            return;
        }
        if (this.isWorkspaceAssignment(assoc)) {
            return;
        }
        long workspaceId = this.workspaceId();
        if (workspaceId == -1L) {
            return;
        }
        this.assignToWorkspace((DeepaMehtaObject)assoc, workspaceId);
    }

    public void preDeleteTopic(Topic topic) {
        if (topic.getTypeUri().equals("dm4.workspaces.workspace")) {
            long workspaceId = topic.getId();
            this.deleteWorkspaceContent(workspaceId);
        }
    }

    private long workspaceId() {
        Cookies cookies = Cookies.get();
        if (!cookies.has("dm4_workspace_id")) {
            return -1L;
        }
        return cookies.getLong("dm4_workspace_id");
    }

    private long workspaceIdForType(DeepaMehtaType type) {
        return this.workspaceId() == -1L && this.isDeepaMehtaStandardType(type) ? this.getDeepaMehtaWorkspace().getId() : -1L;
    }

    private long getAssignedWorkspaceId(long objectId) {
        return this.dm4.getAccessControl().getAssignedWorkspaceId(objectId);
    }

    private void _assignToWorkspace(DeepaMehtaObject object, long workspaceId) {
        this.facetsService.updateFacet(object, "dm4.workspaces.workspace_facet", this.mf.newFacetValueModel("dm4.workspaces.workspace").putRef(workspaceId));
        object.setProperty("dm4.workspaces.workspace_id", (Object)workspaceId, true);
    }

    private void deleteWorkspaceContent(long workspaceId) {
        try {
            String typeUri;
            for (Topic topicType : this.getAssignedTopics(workspaceId, "dm4.core.topic_type")) {
                typeUri = topicType.getUri();
                for (Topic topic : this.dm4.getTopicsByType(typeUri)) {
                    topic.delete();
                }
                this.dm4.getTopicType(typeUri).delete();
            }
            for (Topic assocType : this.getAssignedTopics(workspaceId, "dm4.core.assoc_type")) {
                typeUri = assocType.getUri();
                for (Association assoc : this.dm4.getAssociationsByType(typeUri)) {
                    assoc.delete();
                }
                this.dm4.getAssociationType(typeUri).delete();
            }
            for (Topic topic : this.getAssignedTopics(workspaceId)) {
                topic.delete();
            }
            for (Association assoc : this.getAssignedAssociations(workspaceId)) {
                assoc.delete();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting content of workspace " + workspaceId + " failed", e);
        }
    }

    private boolean isDeepaMehtaStandardType(DeepaMehtaType type) {
        return type.getUri().startsWith("dm4.");
    }

    private boolean isWorkspaceDescription(Topic topic) {
        return topic.getTypeUri().equals("dm4.workspaces.description");
    }

    private boolean isWorkspaceAssignment(Association assoc) {
        return this.dm4.getAccessControl().isWorkspaceAssignment(assoc);
    }

    private Topic getDeepaMehtaWorkspace() {
        return this.getWorkspace("dm4.workspaces.deepamehta");
    }

    private void applyWorkspaceFilter(Iterator<? extends DeepaMehtaObject> objects, long workspaceId) {
        while (objects.hasNext()) {
            DeepaMehtaObject object = objects.next();
            if (this.getAssignedWorkspaceId(object.getId()) == workspaceId) continue;
            objects.remove();
        }
    }

    private void checkWorkspaceId(long topicId) {
        String typeUri = this.dm4.getTopic(topicId).getTypeUri();
        if (!typeUri.equals("dm4.workspaces.workspace")) {
            throw new IllegalArgumentException("Topic " + topicId + " is not a workspace (but of type \"" + typeUri + "\")");
        }
    }

    private boolean workspaceAssignmentIsSuppressed(DeepaMehtaObject object) {
        boolean suppressed = this.dm4.getAccessControl().workspaceAssignmentIsSuppressed();
        if (suppressed) {
            this.logger.fine("Standard workspace assignment for " + this.info(object) + " SUPPRESSED");
        }
        return suppressed;
    }

    private String info(DeepaMehtaObject object) {
        if (object instanceof TopicType) {
            return "topic type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof AssociationType) {
            return "association type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof Topic) {
            return "topic " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\", uri=\"" + object.getUri() + "\")";
        }
        if (object instanceof Association) {
            return "association " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\")";
        }
        throw new RuntimeException("Unexpected object: " + object);
    }
}

