/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.webservice.provider;

import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.util.DeepaMehtaUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
public class JSONEnabledCollectionProvider
implements MessageBodyWriter<Collection<JSONEnabled>> {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (genericType instanceof ParameterizedType) {
            Type[] typeArgs = ((ParameterizedType)genericType).getActualTypeArguments();
            if (Collection.class.isAssignableFrom(type) && typeArgs.length == 1 && JSONEnabled.class.isAssignableFrom((Class)typeArgs[0]) && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                return true;
            }
        }
        return false;
    }

    public long getSize(Collection<JSONEnabled> objects, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Collection<JSONEnabled> objects, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(entityStream));
            DeepaMehtaUtils.toJSONArray(objects).write((Writer)writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("Writing message body failed (" + objects.size() + " objects)", e);
        }
    }
}

