/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.boxrenderer.dom.migrations;

import de.deepamehta.core.Association;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.service.Migration;
import java.util.logging.Logger;

public class Migration1
extends Migration {
    private static final String PROP_COLOR = "dm4.boxrenderer.color";
    private static final String PROP_EXPANDED = "dm4.boxrenderer.expanded";
    private static final String TOPIC_MAPCONTEXT = "dm4.topicmaps.topic_mapcontext";
    private long topics = 0L;
    private long props = 0L;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Moving BoxRenderer properties from topics to \"Topic Mapcontext\" associations");
        for (Topic topic : this.dm4.getAllTopics()) {
            this.migrateBoxRendererProperties(topic);
        }
        this.logger.info("########## Moving BoxRenderer properties complete\n    Topics processed: " + this.topics + "\n    Topics with BoxRenderer properties: " + this.props);
    }

    private void migrateBoxRendererProperties(Topic topic) {
        String color = null;
        Boolean expanded = null;
        ++this.topics;
        if (topic.hasProperty(PROP_COLOR)) {
            color = (String)topic.getProperty(PROP_COLOR);
        }
        if (topic.hasProperty(PROP_EXPANDED)) {
            expanded = (Boolean)topic.getProperty(PROP_EXPANDED);
        }
        if (color != null || expanded != null) {
            ++this.props;
            for (RelatedTopic topicmap : topic.getRelatedTopics(TOPIC_MAPCONTEXT, "dm4.topicmaps.topicmap_topic", "dm4.core.default", "dm4.topicmaps.topicmap")) {
                Association mapcontextAssoc = topicmap.getRelatingAssociation();
                if (color != null) {
                    mapcontextAssoc.setProperty(PROP_COLOR, (Object)color, false);
                }
                if (expanded == null) continue;
                mapcontextAssoc.setProperty(PROP_EXPANDED, (Object)expanded, false);
            }
            topic.removeProperty(PROP_COLOR);
            topic.removeProperty(PROP_EXPANDED);
        }
    }
}

