/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.webclient.migrations;

import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.DeepaMehtaType;
import de.deepamehta.core.Topic;
import de.deepamehta.core.ViewConfiguration;
import de.deepamehta.core.service.Migration;
import java.util.List;
import java.util.logging.Logger;

public class Migration3
extends Migration {
    private long deepaMehtaWorkspaceId;
    private int[][] count = new int[2][2];
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.initDeepaMehtaWorkspaceId();
        this.logger.info("########## Repairing types with missing \"View Config\" topic (" + (this.deepaMehtaWorkspaceId == -1L ? "clean install" : "update") + " detected)");
        this.repair(this.dm4.getAllTopicTypes(), 0);
        this.repair(this.dm4.getAllAssociationTypes(), 1);
        this.logger.info("########## Repairing types with missing \"View Config\" topic complete\n    Topic types repaired: " + this.count[0][1] + "/" + this.count[0][0] + "\n    Association types repaired: " + this.count[1][1] + "/" + this.count[1][0]);
    }

    private void repair(List<? extends DeepaMehtaType> types, int i) {
        for (DeepaMehtaType deepaMehtaType : types) {
            if (deepaMehtaType.getUri().equals("dm4.webclient.view_config")) continue;
            this.repair(deepaMehtaType, i);
        }
    }

    private void repair(DeepaMehtaType type, int i) {
        try {
            ViewConfiguration viewConfig = type.getViewConfig();
            Topic configTopic = viewConfig.getConfigTopic("dm4.webclient.view_config");
            if (configTopic == null) {
                configTopic = viewConfig.addConfigTopic(this.mf.newTopicModel("dm4.webclient.view_config"));
                if (this.deepaMehtaWorkspaceId != -1L && this.isDeepaMehtaStandardType(type)) {
                    this.dm4.getAccessControl().assignToWorkspace((DeepaMehtaObject)configTopic, this.deepaMehtaWorkspaceId);
                }
                int[] nArray = this.count[i];
                nArray[1] = nArray[1] + 1;
            }
            int[] nArray = this.count[i];
            nArray[0] = nArray[0] + 1;
        }
        catch (Exception e) {
            throw new RuntimeException("Repairing type \"" + type.getUri() + "\" failed", e);
        }
    }

    private void initDeepaMehtaWorkspaceId() {
        Topic ws = this.dm4.getTopicByUri("dm4.workspaces.deepamehta");
        this.deepaMehtaWorkspaceId = ws != null ? ws.getId() : -1L;
    }

    private boolean isDeepaMehtaStandardType(DeepaMehtaType type) {
        return type.getUri().startsWith("dm4.");
    }
}

