/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Association;
import systems.dmx.core.RelatedAssociation;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.impl.DMXObjectImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedAssociationModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.TopicModel;

class TopicImpl
extends DMXObjectImpl
implements Topic {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    TopicImpl(TopicModelImpl model, PersistenceLayer pl) {
        super(model, pl);
    }

    @Override
    public final void update(TopicModel updateModel) {
        this.pl.updateTopic(this.getModel(), (TopicModelImpl)updateModel);
    }

    @Override
    public final void delete() {
        this.pl.deleteTopic(this.getModel());
    }

    @Override
    public final Topic findChildTopic(String topicTypeUri) {
        TopicModelImpl topic = this.getModel().findChildTopic(topicTypeUri);
        return topic != null ? topic.instantiate() : null;
    }

    @Override
    public final Topic loadChildTopics() {
        super.loadChildTopics();
        return this;
    }

    @Override
    public final Topic loadChildTopics(String assocDefUri) {
        super.loadChildTopics(assocDefUri);
        return this;
    }

    @Override
    public TopicModelImpl getModel() {
        return (TopicModelImpl)this.model;
    }

    @Override
    public final List<RelatedTopic> getRelatedTopics(List assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.instantiate(this.pl.getTopicRelatedTopics(this.getId(), assocTypeUris, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri));
    }

    @Override
    public final RelatedAssociation getRelatedAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        RelatedAssociationModelImpl assoc = this.pl.getTopicRelatedAssociation(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return assoc != null ? assoc.instantiate() : null;
    }

    @Override
    public final List<RelatedAssociation> getRelatedAssociations(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.pl.instantiate(this.pl.getTopicRelatedAssociations(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri));
    }

    @Override
    public final Association getAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, long othersTopicId) {
        return this.pl.getAssociation(assocTypeUri, this.getId(), othersTopicId, myRoleTypeUri, othersRoleTypeUri);
    }

    @Override
    public final List<Association> getAssociations() {
        return this.pl.instantiate(this.pl.getTopicAssociations(this.getId()));
    }
}

