/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.geomaps.model;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.Topic;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.util.DMXUtils;

public class Geomap
implements Iterable<TopicModel>,
JSONEnabled {
    protected Topic geomapTopic;
    protected Map<Long, TopicModel> geoCoords;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Geomap(Topic geomapTopic, Map<Long, TopicModel> geoCoords) {
        this.geomapTopic = geomapTopic;
        this.geoCoords = geoCoords;
    }

    public long getId() {
        return this.geomapTopic.getId();
    }

    public boolean containsTopic(long geoCoordId) {
        return this.geoCoords.get(geoCoordId) != null;
    }

    public JSONObject toJSON() {
        try {
            return new JSONObject().put("info", (Object)this.geomapTopic.toJSON()).put("geoCoordTopics", (Object)DMXUtils.toJSONArray(this.geoCoords.values()));
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    public Iterator<TopicModel> iterator() {
        return this.geoCoords.values().iterator();
    }

    public String toString() {
        return "geomap " + this.getId();
    }
}

