/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.AssociationDefinition;
import systems.dmx.core.DMXObject;
import systems.dmx.core.DMXType;
import systems.dmx.core.RelatedAssociation;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.impl.ChildTopicsImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PersistenceLayer;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.SimpleValue;

abstract class DMXObjectImpl
implements DMXObject {
    DMXObjectModelImpl model;
    PersistenceLayer pl;
    ModelFactoryImpl mf;

    DMXObjectImpl(DMXObjectModelImpl model, PersistenceLayer pl) {
        this.model = model;
        this.pl = pl;
        this.mf = pl.mf;
    }

    @Override
    public final long getId() {
        return this.model.getId();
    }

    @Override
    public final String getUri() {
        return this.model.getUri();
    }

    @Override
    public final void setUri(String uri) {
        this.model.updateUri(uri);
    }

    @Override
    public final String getTypeUri() {
        return this.model.getTypeUri();
    }

    @Override
    public final void setTypeUri(String typeUri) {
        this.model.updateTypeUri(typeUri);
    }

    @Override
    public final SimpleValue getSimpleValue() {
        return this.model.getSimpleValue();
    }

    @Override
    public final void setSimpleValue(String value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(int value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(long value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(boolean value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public final void setSimpleValue(SimpleValue value) {
        this.model.updateSimpleValue(value);
    }

    @Override
    public final ChildTopicsImpl getChildTopics() {
        return new ChildTopicsImpl(this.model.childTopics, this.model, this.pl);
    }

    @Override
    public final void setChildTopics(ChildTopicsModel childTopics) {
        this.model.updateChildTopics(childTopics);
    }

    @Override
    public DMXObject loadChildTopics() {
        this.model.loadChildTopics(true);
        return this;
    }

    @Override
    public DMXObject loadChildTopics(String assocDefUri) {
        this.model.loadChildTopics(assocDefUri, true);
        return this;
    }

    @Override
    public final DMXType getType() {
        return this.model.getType().instantiate();
    }

    @Override
    public DMXObjectModelImpl getModel() {
        return this.model;
    }

    @Override
    public final void updateChildTopics(ChildTopicsModel updateModel, AssociationDefinition assocDef) {
        this.model.updateChildTopics(updateModel, assocDef.getModel());
    }

    @Override
    public final RelatedTopic getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        RelatedTopicModelImpl topic = this.model.getRelatedTopic(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return topic != null ? (RelatedTopic)this.pl.checkReadAccessAndInstantiate(topic) : null;
    }

    @Override
    public final List<RelatedTopic> getRelatedTopics() {
        return this.getRelatedTopics(null, null, null, null);
    }

    @Override
    public final List<RelatedTopic> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.model.getRelatedTopics(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return this.pl.checkReadAccessAndInstantiate(topics);
    }

    @Override
    public final List<RelatedAssociation> getRelatedAssociations() {
        return this.getRelatedAssociations(null, null, null, null);
    }

    @Override
    public final Object getProperty(String propUri) {
        return this.pl.fetchProperty(this.getId(), propUri);
    }

    @Override
    public final boolean hasProperty(String propUri) {
        return this.pl.hasProperty(this.getId(), propUri);
    }

    @Override
    public final void setProperty(String propUri, Object propValue, boolean addToIndex) {
        this.model.storeProperty(propUri, propValue, addToIndex);
    }

    @Override
    public final void removeProperty(String propUri) {
        this.model.removeProperty(propUri);
    }

    @Override
    public final Object getDatabaseVendorObject() {
        return this.pl.getDatabaseVendorObject(this.getId());
    }

    @Override
    public final JSONObject toJSON() {
        return this.model.toJSON();
    }

    public final boolean equals(Object o) {
        return ((DMXObjectImpl)o).model.equals(this.model);
    }

    public final int hashCode() {
        return this.model.hashCode();
    }

    public final String toString() {
        return this.model.toString();
    }

    final String className() {
        return this.model.className();
    }
}

