/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.impl.AssocImpl;
import systems.dmx.core.impl.AssocTypeModelImpl;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.PlayerModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicPlayerModel;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.Directive;
import systems.dmx.core.util.DMXUtils;

public class AssocModelImpl
extends DMXObjectModelImpl
implements AssocModel {
    PlayerModelImpl player1;
    PlayerModelImpl player2;

    AssocModelImpl(DMXObjectModelImpl object, PlayerModelImpl player1, PlayerModelImpl player2) {
        super(object);
        this.player1 = player1;
        this.player2 = player2;
    }

    AssocModelImpl(AssocModelImpl assoc) {
        super(assoc);
        this.player1 = assoc.player1;
        this.player2 = assoc.player2;
    }

    @Override
    public PlayerModelImpl getPlayer1() {
        return this.player1;
    }

    @Override
    public PlayerModelImpl getPlayer2() {
        return this.player2;
    }

    @Override
    public void setPlayer1(PlayerModel player1) {
        this.player1 = (PlayerModelImpl)player1;
    }

    @Override
    public void setPlayer2(PlayerModel player2) {
        this.player2 = (PlayerModelImpl)player2;
    }

    @Override
    public PlayerModelImpl getPlayerByRole(String roleTypeUri) {
        boolean rm1 = this.player1.getRoleTypeUri().equals(roleTypeUri);
        boolean rm2 = this.player2.getRoleTypeUri().equals(roleTypeUri);
        if (rm1 && rm2) {
            throw new RuntimeException("Ambiguous getPlayerByRole() call: both players play role \"" + roleTypeUri + "\" (" + this + ")");
        }
        return rm1 ? this.player1 : (rm2 ? this.player2 : null);
    }

    @Override
    public boolean hasSameRoleTypeUris() {
        return this.player1.getRoleTypeUri().equals(this.player2.getRoleTypeUri());
    }

    @Override
    public boolean matches(String roleTypeUri1, long playerId1, String roleTypeUri2, long playerId2) {
        if (roleTypeUri1.equals(roleTypeUri2)) {
            throw new IllegalArgumentException("matches() was called with 2 identical role type URIs (\"" + roleTypeUri1 + "\")");
        }
        if (!this.hasSameRoleTypeUris()) {
            PlayerModelImpl r1 = this.getPlayerByRole(roleTypeUri1);
            PlayerModelImpl r2 = this.getPlayerByRole(roleTypeUri2);
            if (r1 != null && r1.getId() == playerId1 && r2 != null && r2.getId() == playerId2) {
                return true;
            }
        }
        return false;
    }

    @Override
    public long getOtherPlayerId(long id) {
        try {
            long id1 = this.player1.getId();
            long id2 = this.player2.getId();
            if (id1 == id) {
                return id2;
            }
            if (id2 == id) {
                return id1;
            }
            throw new IllegalArgumentException(id + " is not a player in " + this);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get other player of " + id + " in " + this, e);
        }
    }

    @Override
    public PlayerModel createPlayerModel(String roleTypeUri) {
        return this.mf.newAssocPlayerModel(this.id, roleTypeUri);
    }

    @Override
    public JSONObject toJSON() {
        try {
            return super.toJSON().put("player1", this.player1 != null ? this.player1.toJSON() : null).put("player2", this.player2 != null ? this.player2.toJSON() : null);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    public AssocModel clone() {
        try {
            AssocModel model = (AssocModel)super.clone();
            model.setPlayer1(this.player1.clone());
            model.setPlayer2(this.player2.clone());
            return model;
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning an AssocModel failed", e);
        }
    }

    @Override
    String className() {
        return "association";
    }

    AssocImpl instantiate() {
        return new AssocImpl(this, this.al);
    }

    @Override
    AssocModelImpl createModelWithChildTopics(ChildTopicsModel childTopics) {
        return this.mf.newAssocModel(this.typeUri, childTopics);
    }

    @Override
    final AssocTypeModelImpl getType() {
        return this.al.typeStorage.getAssocType(this.typeUri);
    }

    @Override
    final List<AssocModelImpl> getAssocs() {
        return this.al.db.fetchAssocAssocs(this.id);
    }

    @Override
    final RelatedTopicModelImpl getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.al.sd.fetchAssocRelatedTopic(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    final List<RelatedTopicModelImpl> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.al.db.fetchAssocRelatedTopics(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    final void storeUri() {
        this.al.db.storeAssocUri(this.id, this.uri);
    }

    @Override
    final void storeTypeUri() {
        this.reassignInstantiation();
        this.al.db.storeAssocTypeUri(this.id, this.typeUri);
    }

    @Override
    final void storeSimpleValue() {
        this.al.db.storeAssocValue(this.id, this.value, this.typeUri, this.isHtml());
    }

    @Override
    final void storeProperty(String propUri, Object propValue, boolean addToIndex) {
        this.al.db.storeAssocProperty(this.id, propUri, propValue, addToIndex);
    }

    @Override
    final void removeProperty(String propUri) {
        this.al.db.deleteAssocProperty(this.id, propUri);
    }

    @Override
    final void _delete() {
        this.al.db.deleteAssoc(this.id);
    }

    @Override
    final <M extends DMXObjectModelImpl> M checkReadAccess() {
        this.al.checkAssocReadAccess(this.id);
        return (M)this;
    }

    @Override
    final void checkWriteAccess() {
        this.al.checkAssocWriteAccess(this.id);
    }

    @Override
    final DMXEvent getPreUpdateEvent() {
        return CoreEvent.PRE_UPDATE_ASSOCIATION;
    }

    @Override
    final DMXEvent getPostUpdateEvent() {
        return CoreEvent.POST_UPDATE_ASSOCIATION;
    }

    @Override
    final DMXEvent getPreDeleteEvent() {
        return CoreEvent.PRE_DELETE_ASSOCIATION;
    }

    @Override
    final DMXEvent getPostDeleteEvent() {
        return CoreEvent.POST_DELETE_ASSOCIATION;
    }

    @Override
    final Directive getUpdateDirective() {
        return Directive.UPDATE_ASSOCIATION;
    }

    @Override
    final Directive getDeleteDirective() {
        return Directive.DELETE_ASSOCIATION;
    }

    @Override
    void preCreate() {
        if (DMXUtils.associationAutoTyping(this, "dmx.core.topic_type", "dmx.core.topic_type", "dmx.core.composition_def", "dmx.core.child_type", "dmx.core.parent_type") != null || DMXUtils.associationAutoTyping(this, "dmx.core.topic_type", "dmx.core.assoc_type", "dmx.core.composition_def", "dmx.core.child_type", "dmx.core.parent_type") != null) {
            this.childTopics.putRef("dmx.core.cardinality", "dmx.core.one");
        }
        this.duplicateCheck();
    }

    @Override
    void postCreate() {
        if (this.isCompDef(this)) {
            this.createCompDef();
        }
    }

    @Override
    void postUpdate(DMXObjectModel updateModel, DMXObjectModel oldObject) {
        this.updatePlayers((AssocModelImpl)updateModel);
        this.duplicateCheck();
        if (this.isCompDef(this)) {
            if (this.isCompDef((AssocModel)oldObject)) {
                this.updateCompDef((AssocModel)oldObject);
            } else {
                this.createCompDef();
            }
        } else if (this.isCompDef((AssocModel)oldObject)) {
            this.removeCompDef();
        }
    }

    @Override
    void preDelete() {
        if (this.isCompDef(this)) {
            this.removeCompDef();
        }
    }

    DMXObjectModelImpl getDMXObjectByRole(String roleTypeUri) {
        PlayerModelImpl player = this.getPlayerByRole(roleTypeUri);
        return player != null ? player.getDMXObject(this) : null;
    }

    DMXObjectModelImpl getDMXObjectByType(String typeUri) {
        DMXObjectModelImpl object1 = this.filter(this.player1, typeUri);
        DMXObjectModelImpl object2 = this.filter(this.player2, typeUri);
        if (object1 != null && object2 != null) {
            throw new RuntimeException("Ambiguous getDMXObjectByType() call: both players are of type \"" + typeUri + "\" (" + this + ")");
        }
        return object1 != null ? object1 : (object2 != null ? object2 : null);
    }

    void updateRoleTypeUri(PlayerModelImpl player, String roleTypeUri) {
        player.setRoleTypeUri(roleTypeUri);
        this.al.db.storeRoleTypeUri(this.id, player.id, player.roleTypeUri);
    }

    private void duplicateCheck() {
        if (!(this.player1 instanceof TopicPlayerModel) || this.player1.id == -1L || !(this.player2 instanceof TopicPlayerModel) || this.player2.id == -1L) {
            return;
        }
        for (AssocModelImpl assoc : this.al.getAssocs(this.typeUri, this.player1.id, this.player2.id, this.player1.roleTypeUri, this.player2.roleTypeUri)) {
            SimpleValue _value;
            SimpleValue simpleValue = _value = this.value != null ? this.value : new SimpleValue("");
            if (assoc.id == this.id || !assoc.value.equals(_value)) continue;
            throw new RuntimeException("Duplicate: such an association exists already, " + this + ", existing assoc=" + assoc);
        }
    }

    private void updatePlayers(AssocModelImpl updateModel) {
        this.updatePlayer(updateModel.player1, 1);
        this.updatePlayer(updateModel.player2, 2);
    }

    private void updatePlayer(PlayerModelImpl updateModel, int nr) {
        try {
            if (updateModel != null) {
                PlayerModelImpl player = this.getPlayer(updateModel);
                String roleTypeUri = player.roleTypeUri;
                String newRoleTypeUri = updateModel.roleTypeUri;
                if (!roleTypeUri.equals(newRoleTypeUri)) {
                    this.logger.info("### Changing role type " + nr + " of association " + this.id + ": \"" + roleTypeUri + "\" -> \"" + newRoleTypeUri + "\"");
                    this.updateRoleTypeUri(player, newRoleTypeUri);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Updating player " + nr + " of association " + this.id + " failed, updateModel=" + updateModel, e);
        }
    }

    private PlayerModelImpl getPlayer(PlayerModel player) {
        long playerId = player.getId();
        if (this.player1.getId() == playerId) {
            return this.player1;
        }
        if (this.player2.getId() == playerId) {
            return this.player2;
        }
        throw new RuntimeException(player + " is not a player in " + this);
    }

    private DMXObjectModelImpl filter(PlayerModelImpl player, String typeUri) {
        DMXObjectModelImpl object = player.getDMXObject(this);
        return object.getTypeUri().equals(typeUri) ? object : null;
    }

    private void reassignInstantiation() {
        this.fetchInstantiation().delete();
        this.al.createAssocInstantiation(this.id, this.typeUri);
    }

    private AssocModelImpl fetchInstantiation() {
        RelatedTopicModelImpl assocType = this.getRelatedTopic("dmx.core.instantiation", "dmx.core.instance", "dmx.core.type", "dmx.core.assoc_type");
        if (assocType == null) {
            throw new RuntimeException("Assoc " + this.id + " is not associated to an association type");
        }
        return assocType.getRelatingAssoc();
    }

    private void createCompDef() {
        TypeModelImpl parentType = this.fetchParentType();
        this.logger.info("##### Adding comp def " + this.id + " to type \"" + parentType.getUri() + "\"");
        parentType._addCompDef(this);
    }

    private void updateCompDef(AssocModel oldAssoc) {
        TypeModelImpl parentType = this.fetchParentType();
        this.logger.info("##### Updating comp def " + this.id + " of type \"" + parentType.getUri() + "\"");
        parentType._updateCompDef(this, oldAssoc);
    }

    private void removeCompDef() {
        TypeModelImpl parentType = this.fetchParentType();
        this.logger.info("##### Removing comp def " + this.id + " from type \"" + parentType.getUri() + "\"");
        parentType._removeCompDefFromMemoryAndRebuildSequence(this);
    }

    private boolean isCompDef(AssocModel assoc) {
        String typeUri = assoc.getTypeUri();
        if (!typeUri.equals("dmx.core.composition_def")) {
            return false;
        }
        if (assoc.hasSameRoleTypeUris()) {
            return false;
        }
        return assoc.getPlayerByRole("dmx.core.parent_type") != null && assoc.getPlayerByRole("dmx.core.child_type") != null;
    }

    private TypeModelImpl fetchParentType() {
        return this.al.typeStorage.fetchParentType(this);
    }
}

