/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.timestamps;

import com.sun.jersey.spi.container.ContainerResponse;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.event.PostCreateAssoc;
import systems.dmx.core.service.event.PostCreateTopic;
import systems.dmx.core.service.event.PostUpdateAssoc;
import systems.dmx.core.service.event.PostUpdateTopic;
import systems.dmx.core.service.event.PreSendAssoc;
import systems.dmx.core.service.event.PreSendTopic;
import systems.dmx.core.service.event.ServiceResponseFilter;
import systems.dmx.timestamps.TimestampsService;

@Path(value="/timestamps")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TimestampsPlugin
extends PluginActivator
implements TimestampsService,
PostCreateTopic,
PostCreateAssoc,
PostUpdateTopic,
PostUpdateAssoc,
PreSendTopic,
PreSendAssoc,
ServiceResponseFilter {
    private static String PROP_CREATED = "dmx.timestamps.created";
    private static String PROP_MODIFIED = "dmx.timestamps.modified";
    private static String HEADER_LAST_MODIFIED = "Last-Modified";
    private DateFormat rfc2822;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/object/{id}/created")
    public long getCreationTime(@PathParam(value="id") long objectId) {
        try {
            return this.dmx.hasProperty(objectId, PROP_CREATED) ? (Long)this.dmx.getProperty(objectId, PROP_CREATED) : 0L;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching creation time of object " + objectId + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/object/{id}/modified")
    public long getModificationTime(@PathParam(value="id") long objectId) {
        try {
            return this.dmx.hasProperty(objectId, PROP_MODIFIED) ? (Long)this.dmx.getProperty(objectId, PROP_MODIFIED) : 0L;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching modification time of object " + objectId + " failed", e);
        }
    }

    @Override
    public void setModified(DMXObject object) {
        this.storeTimestamp(object);
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/topics/created")
    public Collection<Topic> getTopicsByCreationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dmx.getTopicsByPropertyRange(PROP_CREATED, (Number)from, (Number)to);
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/topics/modified")
    public Collection<Topic> getTopicsByModificationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dmx.getTopicsByPropertyRange(PROP_MODIFIED, (Number)from, (Number)to);
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/assocs/created")
    public Collection<Assoc> getAssocsByCreationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dmx.getAssocsByPropertyRange(PROP_CREATED, (Number)from, (Number)to);
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/assocs/modified")
    public Collection<Assoc> getAssocsByModificationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dmx.getAssocsByPropertyRange(PROP_MODIFIED, (Number)from, (Number)to);
    }

    public void init() {
        this.rfc2822 = DateFormat.getDateTimeInstance(2, 2, Locale.ENGLISH);
        this.rfc2822.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        ((SimpleDateFormat)this.rfc2822).applyPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
    }

    public void postCreateTopic(Topic topic) {
        this.storeTimestamps((DMXObject)topic);
    }

    public void postCreateAssoc(Assoc assoc) {
        this.storeTimestamps((DMXObject)assoc);
    }

    public void postUpdateTopic(Topic topic, TopicModel updateModel, TopicModel oldTopic) {
        this.storeTimestamp((DMXObject)topic);
    }

    public void postUpdateAssoc(Assoc assoc, AssocModel updateModel, AssocModel oldAssoc) {
        this.storeTimestamp((DMXObject)assoc);
    }

    public void preSendTopic(Topic topic) {
        this.enrichWithTimestamp((DMXObject)topic);
    }

    public void preSendAssoc(Assoc assoc) {
        this.enrichWithTimestamp((DMXObject)assoc);
    }

    public void serviceResponseFilter(ContainerResponse response) {
        DMXObject object = this.responseObject(response);
        if (object != null) {
            this.setLastModifiedHeader(response, this.getModificationTime(object.getId()));
        }
    }

    private void storeTimestamps(DMXObject object) {
        long time = System.currentTimeMillis();
        this.storeCreationTime(object, time);
        this.storeModificationTime(object, time);
    }

    private void storeTimestamp(DMXObject object) {
        long time = System.currentTimeMillis();
        this.storeModificationTime(object, time);
    }

    private void storeCreationTime(DMXObject object, long time) {
        this.storeTime(object, PROP_CREATED, time);
    }

    private void storeModificationTime(DMXObject object, long time) {
        this.storeTime(object, PROP_MODIFIED, time);
    }

    private void storeTime(DMXObject object, String propUri, long time) {
        object.setProperty(propUri, (Object)time, true);
    }

    private DMXObject responseObject(ContainerResponse response) {
        Object entity = response.getEntity();
        return entity instanceof DMXObject ? (DMXObject)entity : null;
    }

    private void enrichWithTimestamp(DMXObject object) {
        long objectId = object.getId();
        ChildTopicsModel childTopics = object.getChildTopics().getModel().put(PROP_CREATED, (Object)this.getCreationTime(objectId)).put(PROP_MODIFIED, (Object)this.getModificationTime(objectId));
    }

    private void setLastModifiedHeader(ContainerResponse response, long time) {
        this.setHeader(response, HEADER_LAST_MODIFIED, this.rfc2822.format(time));
    }

    private void setHeader(ContainerResponse response, String header, String value) {
        MultivaluedMap headers = response.getHttpHeaders();
        if (headers.containsKey((Object)header)) {
            throw new RuntimeException("Response already has a \"" + header + "\" header");
        }
        headers.putSingle((Object)header, (Object)value);
    }
}

