/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicReferenceModelImpl;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.util.DMXUtils;

class ChildTopicsModelImpl
implements ChildTopicsModel {
    private Map<String, Object> childTopics;
    private ModelFactory mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ChildTopicsModelImpl(Map<String, Object> childTopics, ModelFactory mf) {
        this.childTopics = childTopics;
        this.mf = mf;
    }

    ChildTopicsModelImpl(ChildTopicsModelImpl childTopics) {
        this(childTopics.childTopics, childTopics.mf);
    }

    @Override
    public final RelatedTopicModelImpl getTopic(String compDefUri) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(compDefUri);
        if (topic == null) {
            throw new RuntimeException("Comp Def URI \"" + compDefUri + "\" not found in " + this.childTopics.keySet());
        }
        return topic;
    }

    @Override
    public final RelatedTopicModelImpl getTopicOrNull(String compDefUri) {
        try {
            return (RelatedTopicModelImpl)this.childTopics.get(compDefUri);
        }
        catch (ClassCastException e) {
            this.throwInvalidSingleAccess(compDefUri, e);
            return null;
        }
    }

    public final List<RelatedTopicModelImpl> getTopics(String compDefUri) {
        List<RelatedTopicModelImpl> topics = this.getTopicsOrNull(compDefUri);
        if (topics == null) {
            throw new RuntimeException("Comp Def URI \"" + compDefUri + "\" not found in " + this.childTopics.keySet());
        }
        return topics;
    }

    public final List<RelatedTopicModelImpl> getTopicsOrNull(String compDefUri) {
        try {
            return (List)this.childTopics.get(compDefUri);
        }
        catch (ClassCastException e) {
            this.throwInvalidMultiAccess(compDefUri, e);
            return null;
        }
    }

    @Override
    public final Object get(String compDefUri) {
        return this.childTopics.get(compDefUri);
    }

    @Override
    public final String getString(String compDefUri) {
        return this.getTopic(compDefUri).getSimpleValue().toString();
    }

    @Override
    public final String getString(String compDefUri, String defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(compDefUri);
        return topic != null ? topic.getSimpleValue().toString() : defaultValue;
    }

    @Override
    public final int getInt(String compDefUri) {
        return this.getTopic(compDefUri).getSimpleValue().intValue();
    }

    @Override
    public final int getInt(String compDefUri, int defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(compDefUri);
        return topic != null ? topic.getSimpleValue().intValue() : defaultValue;
    }

    @Override
    public final long getLong(String compDefUri) {
        return this.getTopic(compDefUri).getSimpleValue().longValue();
    }

    @Override
    public final long getLong(String compDefUri, long defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(compDefUri);
        return topic != null ? topic.getSimpleValue().longValue() : defaultValue;
    }

    @Override
    public final double getDouble(String compDefUri) {
        return this.getTopic(compDefUri).getSimpleValue().doubleValue();
    }

    @Override
    public final double getDouble(String compDefUri, double defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(compDefUri);
        return topic != null ? topic.getSimpleValue().doubleValue() : defaultValue;
    }

    @Override
    public final boolean getBoolean(String compDefUri) {
        return this.getTopic(compDefUri).getSimpleValue().booleanValue();
    }

    @Override
    public final boolean getBoolean(String compDefUri, boolean defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(compDefUri);
        return topic != null ? topic.getSimpleValue().booleanValue() : defaultValue;
    }

    @Override
    public final Object getObject(String compDefUri) {
        return this.getTopic(compDefUri).getSimpleValue().value();
    }

    @Override
    public final Object getObject(String compDefUri, Object defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(compDefUri);
        return topic != null ? topic.getSimpleValue().value() : defaultValue;
    }

    @Override
    public final ChildTopicsModel getChildTopicsModel(String compDefUri) {
        return this.getTopic(compDefUri).getChildTopicsModel();
    }

    @Override
    public final ChildTopicsModel getChildTopicsModel(String compDefUri, ChildTopicsModel defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(compDefUri);
        return topic != null ? topic.getChildTopicsModel() : defaultValue;
    }

    @Override
    public final ChildTopicsModel put(String compDefUri, RelatedTopicModel value) {
        try {
            if (value == null) {
                throw new IllegalArgumentException("Tried to put null in a ChildTopicsModel");
            }
            this.childTopics.put(compDefUri, value);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException("Putting a value in a ChildTopicsModel failed (compDefUri=\"" + compDefUri + "\", value=" + value + ")", e);
        }
    }

    @Override
    public final ChildTopicsModel put(String compDefUri, TopicModel value) {
        return this.put(compDefUri, this.mf.newRelatedTopicModel(value));
    }

    @Override
    public final ChildTopicsModel put(String compDefUri, Object value) {
        try {
            return this.put(compDefUri, this.mf.newTopicModel(this.mf.childTypeUri(compDefUri), new SimpleValue(value)));
        }
        catch (Exception e) {
            throw new RuntimeException("Putting a value in a ChildTopicsModel failed (compDefUri=\"" + compDefUri + "\", value=" + value + ")", e);
        }
    }

    @Override
    public final ChildTopicsModel put(String compDefUri, ChildTopicsModel value) {
        return this.put(compDefUri, this.mf.newTopicModel(this.mf.childTypeUri(compDefUri), value));
    }

    @Override
    public final ChildTopicsModel putRef(String compDefUri, long refTopicId) {
        this.put(compDefUri, this.mf.newTopicReferenceModel(refTopicId));
        return this;
    }

    @Override
    public final ChildTopicsModel putRef(String compDefUri, String refTopicUri) {
        this.put(compDefUri, this.mf.newTopicReferenceModel(refTopicUri));
        return this;
    }

    @Override
    public final ChildTopicsModel putDeletionRef(String compDefUri, long refTopicId) {
        this.put(compDefUri, this.mf.newTopicDeletionModel(refTopicId));
        return this;
    }

    @Override
    public final ChildTopicsModel putDeletionRef(String compDefUri, String refTopicUri) {
        this.put(compDefUri, this.mf.newTopicDeletionModel(refTopicUri));
        return this;
    }

    @Override
    public final ChildTopicsModel remove(String compDefUri) {
        this.childTopics.remove(compDefUri);
        return this;
    }

    @Override
    public final ChildTopicsModel add(String compDefUri, RelatedTopicModel value) {
        List<RelatedTopicModelImpl> topics = this.getTopicsOrNull(compDefUri);
        if (topics == null) {
            topics = new ArrayList<RelatedTopicModelImpl>();
            this.childTopics.put(compDefUri, topics);
        }
        topics.add((RelatedTopicModelImpl)value);
        return this;
    }

    @Override
    public final ChildTopicsModel add(String compDefUri, TopicModel value) {
        return this.add(compDefUri, this.mf.newRelatedTopicModel(value));
    }

    @Override
    public final ChildTopicsModel add(String compDefUri, Object value) {
        return this.add(compDefUri, this.mf.newTopicModel(this.mf.childTypeUri(compDefUri), new SimpleValue(value)));
    }

    @Override
    public final ChildTopicsModel put(String compDefUri, List<RelatedTopicModel> values) {
        this.childTopics.put(compDefUri, values);
        return this;
    }

    @Override
    public final ChildTopicsModel remove(String compDefUri, TopicModel value) {
        List<RelatedTopicModelImpl> topics = this.getTopicsOrNull(compDefUri);
        if (topics != null) {
            topics.remove(value);
        }
        return this;
    }

    @Override
    public final ChildTopicsModel addRef(String compDefUri, long refTopicId) {
        this.add(compDefUri, this.mf.newTopicReferenceModel(refTopicId));
        return this;
    }

    @Override
    public final ChildTopicsModel addRef(String compDefUri, String refTopicUri) {
        this.add(compDefUri, this.mf.newTopicReferenceModel(refTopicUri));
        return this;
    }

    @Override
    public final ChildTopicsModel addDeletionRef(String compDefUri, long refTopicId) {
        this.add(compDefUri, this.mf.newTopicDeletionModel(refTopicId));
        return this;
    }

    @Override
    public final ChildTopicsModel addDeletionRef(String compDefUri, String refTopicUri) {
        this.add(compDefUri, this.mf.newTopicDeletionModel(refTopicUri));
        return this;
    }

    @Override
    public final Iterator<String> iterator() {
        return this.childTopics.keySet().iterator();
    }

    @Override
    public final JSONObject toJSON() {
        try {
            JSONObject json = new JSONObject();
            for (String compDefUri : this) {
                Object value = this.get(compDefUri);
                if (value instanceof RelatedTopicModel) {
                    json.put(compDefUri, (Object)((RelatedTopicModel)value).toJSON());
                    continue;
                }
                if (value instanceof List) {
                    json.put(compDefUri, (Object)DMXUtils.toJSONArray((List)value));
                    continue;
                }
                throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
            }
            return json;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    public String toString() {
        return this.childTopics.toString();
    }

    @Override
    public final ChildTopicsModel clone() {
        ChildTopicsModel clone = this.mf.newChildTopicsModel();
        for (String compDefUri : this) {
            Object value = this.get(compDefUri);
            if (value instanceof RelatedTopicModel) {
                RelatedTopicModel model = (RelatedTopicModel)value;
                clone.put(compDefUri, (TopicModel)model.clone());
                continue;
            }
            if (value instanceof List) {
                for (RelatedTopicModel model : (List)value) {
                    clone.add(compDefUri, (TopicModel)model.clone());
                }
                continue;
            }
            throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
        }
        return clone;
    }

    RelatedTopicModelImpl findChildTopicById(long childTopicId, CompDefModel compDef) {
        List<RelatedTopicModelImpl> childTopics = this.getTopicsOrNull(compDef.getCompDefUri());
        if (childTopics != null) {
            for (RelatedTopicModelImpl childTopic : childTopics) {
                if (childTopic.getId() != childTopicId) continue;
                return childTopic;
            }
        }
        return null;
    }

    RelatedTopicModelImpl findChildTopicByRef(TopicReferenceModelImpl topicRef, CompDefModel compDef) {
        List<RelatedTopicModelImpl> childTopics = this.getTopicsOrNull(compDef.getCompDefUri());
        if (childTopics != null) {
            return topicRef.findReferencedTopic(childTopics);
        }
        return null;
    }

    boolean has(String compDefUri) {
        return this.childTopics.containsKey(compDefUri);
    }

    int size() {
        return this.childTopics.size();
    }

    void putInChildTopics(RelatedTopicModel childTopic, CompDefModel compDef) {
        this.put(compDef.getCompDefUri(), childTopic);
    }

    void removeChildTopic(CompDefModel compDef) {
        this.remove(compDef.getCompDefUri());
    }

    void addToChildTopics(RelatedTopicModel childTopic, CompDefModel compDef) {
        this.add(compDef.getCompDefUri(), childTopic);
    }

    void removeFromChildTopics(RelatedTopicModel childTopic, CompDefModel compDef) {
        this.remove(compDef.getCompDefUri(), childTopic);
    }

    private void throwInvalidSingleAccess(String compDefUri, ClassCastException e) {
        if (e.getMessage().startsWith("java.util.ArrayList cannot be cast to")) {
            throw new RuntimeException("\"" + compDefUri + "\" is accessed as single but is defined as multi", e);
        }
        throw new RuntimeException("Accessing \"" + compDefUri + "\" failed", e);
    }

    private void throwInvalidMultiAccess(String compDefUri, ClassCastException e) {
        if (e.getMessage().endsWith("cannot be cast to java.util.List")) {
            throw new RuntimeException("\"" + compDefUri + "\" is accessed as multi but is defined as single", e);
        }
        throw new RuntimeException("Accessing \"" + compDefUri + " failed", e);
    }
}

