/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.service.accesscontrol;

import java.util.HashMap;
import java.util.Map;

public enum SharingMode {
    PRIVATE("dmx.workspaces.private"),
    CONFIDENTIAL("dmx.workspaces.confidential"),
    COLLABORATIVE("dmx.workspaces.collaborative"),
    PUBLIC("dmx.workspaces.public"),
    COMMON("dmx.workspaces.common");

    private static Map<String, SharingMode> sharingModes;
    private final String uri;

    private SharingMode(String uri) {
        this.uri = uri;
        this.put(uri, this);
    }

    public String getUri() {
        return this.uri;
    }

    public static SharingMode fromString(String uri) {
        SharingMode sharingMode = sharingModes.get(uri);
        if (sharingMode == null) {
            throw new RuntimeException("\"" + uri + "\" is an unexpected sharing mode URI");
        }
        return sharingMode;
    }

    private void put(String uri, SharingMode sharingMode) {
        if (sharingModes == null) {
            sharingModes = new HashMap<String, SharingMode>();
        }
        sharingModes.put(uri, sharingMode);
    }
}

