/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.CoreServiceImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.storage.spi.DMXStorage;
import systems.dmx.core.storage.spi.DMXStorageFactory;

public class CoreActivator
implements BundleActivator {
    private static final String DATABASE_FACTORY = "systems.dmx.storage.neo4j.Neo4jStorageFactory";
    private static final String DATABASE_PATH = System.getProperty("dmx.database.path", "dmx-db");
    private static BundleContext bundleContext;
    private DMXStorage db;
    private static ModelFactoryImpl mf;
    private static HttpService httpService;
    private ServiceTracker httpServiceTracker;
    private CoreServiceImpl dmx;
    private static Logger logger;

    public void start(BundleContext bundleContext) {
        try {
            logger.info("========== Starting \"DMX Core\" ==========");
            CoreActivator.bundleContext = bundleContext;
            this.db = CoreActivator.openDB(DATABASE_FACTORY, DATABASE_PATH);
            this.httpServiceTracker = this.createServiceTracker(HttpService.class);
            this.httpServiceTracker.open();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "An error occurred while starting \"DMX Core\":", e);
        }
    }

    public void stop(BundleContext bundleContext) {
        try {
            logger.info("========== Stopping \"DMX Core\" ==========");
            if (this.httpServiceTracker != null) {
                this.httpServiceTracker.close();
            }
            if (this.dmx != null) {
                this.dmx.shutdown();
            }
            if (this.db != null) {
                logger.info("### Shutting down the database");
                this.db.shutdown();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "An error occurred while stopping \"DMX Core\":", e);
        }
    }

    public static CoreService getCoreService() {
        return CoreActivator.getService(CoreService.class);
    }

    public static ModelFactory getModelFactory() {
        return mf;
    }

    public static HttpService getHttpService() {
        return httpService;
    }

    public static <S> S getService(Class<S> clazz) {
        if (bundleContext == null) {
            throw new RuntimeException("Core bundle context not available");
        }
        Object serviceObject = bundleContext.getService(bundleContext.getServiceReference(clazz));
        if (serviceObject == null) {
            throw new RuntimeException("Service \"" + clazz.getName() + "\" not available");
        }
        return (S)serviceObject;
    }

    public static DMXStorage openDB(String databaseFactory, String databasePath) {
        try {
            logger.info("##### Opening the database\n  databaseFactory=\"" + databaseFactory + "\"\n  databasePath=\"" + databasePath + "\"");
            DMXStorageFactory factory = (DMXStorageFactory)Class.forName(databaseFactory).newInstance();
            DMXStorage db = factory.newDMXStorage(databasePath, mf);
            logger.info("Database opened successfully");
            return db;
        }
        catch (Exception e) {
            throw new RuntimeException("Opening the database failed, databaseFactory=\"" + databaseFactory + "\", databasePath=\"" + databasePath + "\"", e);
        }
    }

    private ServiceTracker createServiceTracker(Class serviceInterface) {
        return new ServiceTracker(bundleContext, serviceInterface.getName(), null){

            public Object addingService(ServiceReference serviceRef) {
                Object service = null;
                try {
                    service = super.addingService(serviceRef);
                    CoreActivator.this.addService(service);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "", e);
                }
                return service;
            }

            public void removedService(ServiceReference ref, Object service) {
                try {
                    CoreActivator.this.removeService(service);
                    super.removedService(ref, service);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "", e);
                }
            }
        };
    }

    private void addService(Object service) {
        if (service instanceof HttpService) {
            logger.fine("Adding HTTP service to DMX Core");
            httpService = (HttpService)service;
            this.checkRequirementsForActivation();
        }
    }

    private void removeService(Object service) {
        if (service == httpService) {
            logger.fine("Removing HTTP service from DMX Core");
            httpService = null;
        }
    }

    private void checkRequirementsForActivation() {
        if (httpService != null) {
            this.dmx = new CoreServiceImpl(new AccessLayer(this.db), bundleContext);
            this.dmx.getWebSocketService().start();
            logger.info("Registering DMX core service at OSGi framework");
            bundleContext.registerService(CoreService.class.getName(), (Object)this.dmx, null);
        }
    }

    static {
        mf = new ModelFactoryImpl();
        logger = Logger.getLogger(CoreActivator.class.getName());
    }
}

