/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.storage.spi.DMXStorage;

public class StorageDecorator {
    private final DMXStorage db;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    StorageDecorator(DMXStorage db) {
        this.db = db;
    }

    public TopicModelImpl fetchTopic(String key, Object value) {
        try {
            List<TopicModelImpl> topics = this.db.fetchTopics(key, value);
            int size = topics.size();
            switch (size) {
                case 0: {
                    return null;
                }
                case 1: {
                    return topics.get(0);
                }
            }
            throw new RuntimeException("Ambiguity: " + size + " topics do match, key=\"" + key + "\", value=" + value);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic by value failed", e);
        }
    }

    public AssocModelImpl fetchAssoc(String key, Object value) {
        try {
            List<AssocModelImpl> assocs = this.db.fetchAssocs(key, value);
            int size = assocs.size();
            switch (size) {
                case 0: {
                    return null;
                }
                case 1: {
                    return assocs.get(0);
                }
            }
            throw new RuntimeException("Ambiguity: " + size + " assocs do match, key=\"" + key + "\", value=" + value);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching assoc by value failed", e);
        }
    }

    final AssocModelImpl fetchAssoc(String assocTypeUri, long topicId1, long topicId2, String roleTypeUri1, String roleTypeUri2) {
        List<AssocModelImpl> assocs = this.db.fetchAssocs(assocTypeUri, topicId1, topicId2, roleTypeUri1, roleTypeUri2);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.get(0);
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " \"" + assocTypeUri + "\" associations (topicId1=" + topicId1 + ", topicId2=" + topicId2 + ", roleTypeUri1=\"" + roleTypeUri1 + "\", roleTypeUri2=\"" + roleTypeUri2 + "\")");
    }

    final AssocModelImpl fetchAssocBetweenTopicAndAssoc(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        List<AssocModelImpl> assocs = this.db.fetchAssocsBetweenTopicAndAssoc(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.get(0);
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " \"" + assocTypeUri + "\" associations (topicId=" + topicId + ", assocId=" + assocId + ", topicRoleTypeUri=\"" + topicRoleTypeUri + "\", assocRoleTypeUri=\"" + assocRoleTypeUri + "\")");
    }

    final RelatedTopicModelImpl fetchTopicRelatedTopic(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.db.fetchTopicRelatedTopics(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        switch (topics.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.size() + " related topics (topicId=" + topicId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    final RelatedAssocModelImpl fetchTopicRelatedAssoc(long topicId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        List<RelatedAssocModelImpl> assocs = this.db.fetchTopicRelatedAssocs(topicId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " related associations (topicId=" + topicId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersAssocTypeUri=\"" + othersAssocTypeUri + "\")");
    }

    final RelatedTopicModelImpl fetchAssocRelatedTopic(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.db.fetchAssocRelatedTopics(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        switch (topics.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.size() + " related topics (assocId=" + assocId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    final RelatedAssocModelImpl fetchAssocRelatedAssoc(long assocId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        List<RelatedAssocModelImpl> assocs = this.db.fetchAssocRelatedAssocs(assocId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        switch (assocs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return assocs.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + assocs.size() + " related associations (assocId=" + assocId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersAssocTypeUri=\"" + othersAssocTypeUri + "\"),\nresult=" + assocs);
    }

    final RelatedTopicModelImpl fetchRelatedTopic(long objectId, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.db.fetchRelatedTopics(objectId, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        switch (topics.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return topics.iterator().next();
            }
        }
        throw new RuntimeException("Ambiguity: there are " + topics.size() + " related topics (objectId=" + objectId + ", assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")");
    }

    final boolean init() {
        boolean isCleanInstall = this.db.setupRootNode();
        if (isCleanInstall) {
            this.logger.info("Clean install detected -- Starting with a fresh DB");
            this.storeMigrationNr(0);
        }
        return isCleanInstall;
    }

    final int fetchMigrationNr() {
        return (Integer)this.db.fetchProperty(0L, "core_migration_nr");
    }

    final void storeMigrationNr(int migrationNr) {
        this.db.storeTopicProperty(0L, "core_migration_nr", migrationNr, false);
    }
}

