/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.config;

import systems.dmx.config.ConfigCustomizer;
import systems.dmx.config.ConfigModificationRole;
import systems.dmx.config.ConfigTarget;
import systems.dmx.core.Topic;
import systems.dmx.core.model.TopicModel;

public class ConfigDefinition {
    private ConfigTarget target;
    private String configurableUri;
    private TopicModel defaultConfigTopic;
    private ConfigModificationRole role;
    private ConfigCustomizer customizer;

    public ConfigDefinition(ConfigTarget target, String configurableUri, TopicModel defaultConfigTopic, ConfigModificationRole role) {
        this(target, configurableUri, defaultConfigTopic, role, null);
    }

    public ConfigDefinition(ConfigTarget target, String configurableUri, TopicModel defaultConfigTopic, ConfigModificationRole role, ConfigCustomizer customizer) {
        this.target = target;
        this.configurableUri = configurableUri;
        this.defaultConfigTopic = defaultConfigTopic;
        this.role = role;
        this.customizer = customizer;
    }

    public boolean equals(Object o) {
        return this.getConfigTypeUri().equals(((ConfigDefinition)o).getConfigTypeUri());
    }

    public int hashCode() {
        return this.getConfigTypeUri().hashCode();
    }

    String getHashKey() {
        return this.target.hashKey(this.configurableUri);
    }

    String getConfigTypeUri() {
        return this.defaultConfigTopic.getTypeUri();
    }

    TopicModel getConfigValue(Topic topic) {
        TopicModel configValue;
        if (this.customizer != null && (configValue = this.customizer.getConfigValue(topic)) != null) {
            return configValue;
        }
        return this.defaultConfigTopic;
    }

    ConfigModificationRole getConfigModificationRole() {
        return this.role;
    }
}

