/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.webclient.migrations;

import java.util.logging.Logger;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RoleType;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Migration;

public class Migration6
extends Migration {
    private long dmxWorkspaceId;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        int count = 0;
        int assigned = 0;
        this.initDMXWorkspaceId();
        for (RoleType roleType : this.dmx.getAllRoleTypes()) {
            Topic configTopic = roleType.getViewConfig().addConfigTopic(this.mf.newTopicModel("dmx.webclient.view_config"));
            if (this.dmxWorkspaceId != -1L && this.isDMXStandardType((Topic)roleType)) {
                this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)configTopic, this.dmxWorkspaceId);
                ++assigned;
            }
            ++count;
        }
        this.dmx.getRoleType("dmx.core.child_type").getViewConfig().setConfigValue("dmx.webclient.view_config", "dmx.webclient.arrow_shape", (Object)"triangle");
        this.dmx.getRoleType("dmx.core.child").getViewConfig().setConfigValue("dmx.webclient.view_config", "dmx.webclient.arrow_shape", (Object)"triangle");
        this.dmx.getRoleType("dmx.core.type").getViewConfig().setConfigValue("dmx.webclient.view_config", "dmx.webclient.arrow_shape", (Object)"triangle");
        this.logger.info("##### Adding view configs to role types complete\n    View configs added: " + count + "\n    Assigned to DMX workspace: " + assigned);
    }

    private void initDMXWorkspaceId() {
        Topic ws = this.dmx.getTopicByUri("dmx.workspaces.dmx");
        this.dmxWorkspaceId = ws != null ? ws.getId() : -1L;
    }

    private boolean isDMXStandardType(Topic roleType) {
        return roleType.getUri().startsWith("dmx.");
    }
}

