/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.config.ConfigDef;
import systems.dmx.config.ConfigDefs;
import systems.dmx.config.ConfigModRole;
import systems.dmx.config.ConfigService;
import systems.dmx.config.ConfigTarget;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.DirectivesResponse;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.service.event.PostCreateTopic;

@Path(value="/config")
@Produces(value={"application/json"})
public class ConfigPlugin
extends PluginActivator
implements ConfigService,
PostCreateTopic {
    private Map<String, List<ConfigDef>> registry = new HashMap<String, List<ConfigDef>>();
    @Context
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    public ConfigDefs getConfigDefs() {
        try {
            JSONObject json = new JSONObject();
            PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            for (String configurableUri : this.registry.keySet()) {
                JSONArray array = new JSONArray();
                for (ConfigDef configDef : this.lookupConfigDefs(configurableUri)) {
                    long workspaceId;
                    String username = pa.getUsername(this.request);
                    if (!pa.hasReadPermission(username, workspaceId = this.workspaceId(configDef.getConfigModRole()))) continue;
                    array.put((Object)configDef.getConfigTypeUri());
                }
                if (array.length() <= 0) continue;
                json.put(configurableUri, (Object)array);
            }
            return new ConfigDefs(json);
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving the registered config definitions failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/{configTypeUri}/topic/{topicId}")
    public RelatedTopic getConfigTopic(@PathParam(value="configTypeUri") String configTypeUri, @PathParam(value="topicId") long topicId) {
        return this._getConfigTopic(configTypeUri, topicId);
    }

    @Override
    @PUT
    @Path(value="/topic/{topicId}")
    @Transactional
    public DirectivesResponse updateConfigTopic(@PathParam(value="topicId") long topicId, TopicModel updateModel) {
        try {
            Topic topic = this.dmx.getTopic(topicId);
            String configTypeUri = updateModel.getTypeUri();
            RelatedTopic oldConfigTopic = this.getConfigTopic(configTypeUri, topicId);
            ConfigDef configDef = this.getApplicableConfigDef(topic, configTypeUri);
            long workspaceId = this.workspaceId(configDef.getConfigModRole());
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(workspaceId, () -> {
                Topic configTopic = this.dmx.createTopic(updateModel);
                if (!configTopic.equals(oldConfigTopic)) {
                    this.logger.info("change " + oldConfigTopic.getId() + " -> " + configTopic.getId());
                    oldConfigTopic.getRelatingAssoc().delete();
                    this.createConfigAssoc(topic, configTopic);
                } else {
                    this.logger.info("no change");
                }
                return null;
            });
            return new DirectivesResponse();
        }
        catch (Exception e) {
            throw new RuntimeException("Updating config for topic " + topicId + " failed", e);
        }
    }

    @Override
    public void createConfigTopic(String configTypeUri, Topic topic) {
        this._createConfigTopic(this.getApplicableConfigDef(topic, configTypeUri), topic);
    }

    @Override
    public void registerConfigDef(ConfigDef configDef) {
        try {
            if (this.isRegistered(configDef)) {
                throw new RuntimeException("A definition for config type \"" + configDef.getConfigTypeUri() + "\" is already registered");
            }
            String hashKey = configDef.getHashKey();
            List<ConfigDef> configDefs = this.lookupConfigDefs(hashKey);
            if (configDefs == null) {
                configDefs = new ArrayList<ConfigDef>();
                this.registry.put(hashKey, configDefs);
            }
            configDefs.add(configDef);
        }
        catch (Exception e) {
            throw new RuntimeException("Registering a config definition failed", e);
        }
    }

    @Override
    public void unregisterConfigDef(String configTypeUri) {
        try {
            for (List<ConfigDef> configDefs : this.registry.values()) {
                ConfigDef configDef = this.findByConfigTypeUri(configDefs, configTypeUri);
                if (configDef == null) continue;
                if (!configDefs.remove(configDef)) {
                    throw new RuntimeException("Config definition could not be removed from registry");
                }
                return;
            }
            throw new RuntimeException("No such config definition registered");
        }
        catch (Exception e) {
            throw new RuntimeException("Unregistering definition for config type \"" + configTypeUri + "\" failed", e);
        }
    }

    public void postCreateTopic(Topic topic) {
        for (ConfigDef configDef : this.getApplicableConfigDefs(topic)) {
            this._createConfigTopic(configDef, topic);
        }
    }

    private RelatedTopic _getConfigTopic(String configTypeUri, long topicId) {
        return this.dmx.getPrivilegedAccess().getConfigTopic(configTypeUri, topicId);
    }

    private void _createConfigTopic(ConfigDef configDef, Topic topic) {
        String configTypeUri = configDef.getConfigTypeUri();
        try {
            this.logger.info("Creating config topic of type \"" + configTypeUri + "\" for topic " + topic.getId());
            PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            RelatedTopic configTopic = (RelatedTopic)pa.runInWorkspaceContext(-1L, () -> (RelatedTopic)this.createConfigAssoc(topic, this.dmx.createTopic(configDef.getConfigValue(topic))).getDMXObjectByRole("dmx.core.default"));
            long workspaceId = this.workspaceId(configDef.getConfigModRole());
            pa.assignToWorkspace((DMXObject)configTopic, workspaceId);
            pa.assignToWorkspace((DMXObject)configTopic.getRelatingAssoc(), workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating config topic of type \"" + configTypeUri + "\" for topic " + topic.getId() + " failed", e);
        }
    }

    private Assoc createConfigAssoc(Topic topic, Topic configTopic) {
        return this.dmx.createAssoc(this.mf.newAssocModel("dmx.config.configuration", (PlayerModel)this.mf.newTopicPlayerModel(topic.getId(), "dmx.config.configurable"), (PlayerModel)this.mf.newTopicPlayerModel(configTopic.getId(), "dmx.core.default")));
    }

    private long workspaceId(ConfigModRole role) {
        PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
        switch (role) {
            case ADMIN: {
                return pa.getAdminWorkspaceId();
            }
            case SYSTEM: {
                return pa.getSystemWorkspaceId();
            }
        }
        throw new RuntimeException("Modification role \"" + (Object)((Object)role) + "\" not yet implemented");
    }

    private List<ConfigDef> getApplicableConfigDefs(Topic topic) {
        ArrayList configDefs1 = this.lookupConfigDefs(ConfigTarget.SINGLETON.hashKey(topic));
        List<ConfigDef> configDefs2 = this.lookupConfigDefs(ConfigTarget.TYPE_INSTANCES.hashKey(topic));
        if (configDefs1 != null && configDefs2 != null) {
            ArrayList<ConfigDef> configDefs = new ArrayList<ConfigDef>();
            configDefs.addAll(configDefs1);
            configDefs.addAll(configDefs2);
            return configDefs;
        }
        return configDefs1 != null ? configDefs1 : (configDefs2 != null ? configDefs2 : new ArrayList());
    }

    private ConfigDef getApplicableConfigDef(Topic topic, String configTypeUri) {
        List<ConfigDef> configDefs = this.getApplicableConfigDefs(topic);
        if (configDefs.size() == 0) {
            throw new RuntimeException("None of the registered config definitions are applicable to " + this.info(topic));
        }
        ConfigDef configDef = this.findByConfigTypeUri(configDefs, configTypeUri);
        if (configDef == null) {
            throw new RuntimeException("For " + this.info(topic) + " no config definition for type \"" + configTypeUri + "\" registered");
        }
        return configDef;
    }

    private boolean isRegistered(ConfigDef configDef) {
        for (List<ConfigDef> configDefs : this.registry.values()) {
            if (!configDefs.contains(configDef)) continue;
            return true;
        }
        return false;
    }

    private ConfigDef findByConfigTypeUri(List<ConfigDef> configDefs, String configTypeUri) {
        for (ConfigDef configDef : configDefs) {
            if (!configDef.getConfigTypeUri().equals(configTypeUri)) continue;
            return configDef;
        }
        return null;
    }

    private List<ConfigDef> lookupConfigDefs(String hashKey) {
        return this.registry.get(hashKey);
    }

    private String info(Topic topic) {
        return "topic " + topic.getId() + " (value=\"" + topic.getSimpleValue() + "\", typeUri=\"" + topic.getTypeUri() + "\", uri=\"" + topic.getUri() + "\")";
    }
}

