/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import systems.dmx.core.impl.WebSocketConnectionImpl;

class WebSocketConnectionPool {
    private Map<String, WebSocketConnectionImpl> pool = new ConcurrentHashMap<String, WebSocketConnectionImpl>();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    WebSocketConnectionPool() {
    }

    WebSocketConnectionImpl getConnection(String clientId) {
        WebSocketConnectionImpl connection = this.pool.get(clientId);
        if (connection == null) {
            this.logger.warning("No WebSocket connection open for client ID " + clientId);
        }
        return connection;
    }

    Collection<WebSocketConnectionImpl> getAllConnections() {
        return this.pool.values();
    }

    void addConnection(WebSocketConnectionImpl connection) {
        this.pool.put(connection.clientId, connection);
    }

    void removeConnection(WebSocketConnectionImpl connection) {
        boolean removed;
        boolean bl = removed = this.pool.remove(connection.clientId) != null;
        if (!removed) {
            throw new RuntimeException("Can't remove WebSocket connection " + connection.clientId + " (client ID) from pool");
        }
    }

    void close() {
        this.logger.info("Closing " + this.pool.size() + " WebSocket connections");
        this.getAllConnections().forEach(WebSocketConnectionImpl::close);
    }
}

