/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.DMXObject;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.util.DMXUtils;

class ViewPropsImpl
implements ViewProps {
    private Map<String, Object> viewProps = new HashMap<String, Object>();

    ViewPropsImpl(JSONObject viewProps) {
        DMXUtils.toMap(viewProps, this.viewProps);
    }

    ViewPropsImpl() {
    }

    ViewPropsImpl(int x, int y) {
        this.initPos(x, y);
    }

    ViewPropsImpl(int x, int y, boolean visibility, boolean pinned) {
        this.initPos(x, y);
        this.initVisibility(visibility);
        this.initPinned(pinned);
    }

    ViewPropsImpl(boolean visibility) {
        this.initVisibility(visibility);
    }

    ViewPropsImpl(boolean visibility, boolean pinned) {
        this.initVisibility(visibility);
        this.initPinned(pinned);
    }

    @Override
    public Object get(String propUri) {
        return this.viewProps.get(propUri);
    }

    @Override
    public int getInt(String propUri) {
        return (Integer)this.get(propUri);
    }

    @Override
    public boolean getBoolean(String propUri) {
        return (Boolean)this.get(propUri);
    }

    @Override
    public ViewProps set(String propUri, Object value) {
        this.viewProps.put(propUri, value);
        return this;
    }

    @Override
    public void store(DMXObject object) {
        for (String propUri : this) {
            object.setProperty(propUri, this.get(propUri), false);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.viewProps.keySet().iterator();
    }

    @Override
    public JSONObject toJSON() {
        return new JSONObject(this.viewProps);
    }

    public String toString() {
        return this.viewProps.toString();
    }

    private void initPos(int x, int y) {
        this.set("dmx.topicmaps.x", x);
        this.set("dmx.topicmaps.y", y);
    }

    private void initVisibility(boolean visibility) {
        this.set("dmx.topicmaps.visibility", visibility);
    }

    private void initPinned(boolean pinned) {
        this.set("dmx.topicmaps.pinned", pinned);
    }
}

