/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.websocket.WebSocket;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.WebSocketConnectionPool;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.websocket.WebSocketConnection;

class WebSocketConnectionImpl
implements WebSocketConnection,
WebSocket,
WebSocket.OnTextMessage,
WebSocket.OnBinaryMessage {
    String clientId;
    private HttpSession session;
    private WebSocketConnectionPool pool;
    private CoreService dmx;
    private WebSocket.Connection connection;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    WebSocketConnectionImpl(String clientId, HttpSession session, WebSocketConnectionPool pool, CoreService dmx) {
        this.clientId = clientId;
        this.session = session;
        this.pool = pool;
        this.dmx = dmx;
        this.logger.info("### Associating WebSocket connection " + clientId + " with " + this.info(session));
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getUsername() {
        return this.username(this.session);
    }

    public void onOpen(WebSocket.Connection connection) {
        this.logger.info("Opening WebSocket connection " + this.clientId);
        this.connection = connection;
        this.pool.addConnection(this);
    }

    public void onClose(int code, String message) {
        this.logger.info("Closing WebSocket connection " + this.clientId);
        this.pool.removeConnection(this);
    }

    public void onMessage(String message) {
        try {
            this.dmx.fireEvent(CoreEvent.WEBSOCKET_TEXT_MESSAGE, message);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "An error occurred while processing WebSocket message \"" + message + "\"", e);
        }
    }

    public void onMessage(byte[] data, int offset, int length) {
    }

    void sendMessage(String message) {
        try {
            this.connection.sendMessage(message);
        }
        catch (Exception e) {
            this.pool.removeConnection(this);
            this.logger.log(Level.SEVERE, "Sending message via " + this + " failed -- connection removed from pool", e);
        }
    }

    void close() {
        this.connection.close();
    }

    private String info(HttpSession session) {
        return "session" + (session != null ? " " + session.getId() + " (username=" + this.username(session) + ")" : ": null");
    }

    private String username(HttpSession session) {
        return this.dmx.getPrivilegedAccess().username(session);
    }
}

