/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.ldap.profile.repository.jndi;

import de.deepamehta.ldap.Configuration;
import de.deepamehta.ldap.PluginLog;
import de.deepamehta.ldap.profile.model.LdapAttribute;
import de.deepamehta.ldap.profile.model.Session;
import de.deepamehta.ldap.profile.repository.LdapRepository;
import de.deepamehta.ldap.profile.repository.jndi.ContextManager;
import de.deepamehta.ldap.profile.repository.jndi.JndiLdapRepository$$Lambda$1;
import de.deepamehta.ldap.profile.repository.jndi.JndiLdapRepository$$Lambda$3;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;

public class JndiLdapRepository
implements LdapRepository {
    private final ContextManager contextManager;

    public JndiLdapRepository(Configuration configuration, PluginLog log) {
        this.contextManager = new ContextManager(configuration, log);
    }

    @Override
    public Session openConnection(String uid) {
        LdapContext result = this.contextManager.openConnection(uid);
        return result != null ? new JndiSession(uid, result) : null;
    }

    @Override
    public void closeConnection(Session session) {
        this.contextManager.closeQuietly(this.ourSession((Session)session).context);
    }

    @Override
    public boolean storeAttribute(Session session, LdapAttribute attribute, String encodedValue) {
        JndiSession jndiSession = this.ourSession(session);
        String entryDN = this.contextManager.dnByUid(jndiSession.uid);
        return this.contextManager.store(JndiLdapRepository$$Lambda$1.lambdaFactory$(attribute, encodedValue, jndiSession, entryDN));
    }

    @Override
    public String loadAttribute(Session session, LdapAttribute attribute) {
        JndiSession jndiSession = this.ourSession(session);
        String entryDN = this.contextManager.dnByUid(jndiSession.uid);
        return (String)this.contextManager.load(JndiLdapRepository$$Lambda$3.lambdaFactory$(jndiSession, entryDN, attribute));
    }

    private static String safeToString(Attribute attribute) throws NamingException {
        return attribute != null ? attribute.get().toString() : null;
    }

    private JndiSession ourSession(Session session) {
        try {
            return (JndiSession)session;
        }
        catch (ClassCastException exception) {
            throw new IllegalStateException(String.format("API was called with wrong session instance. Must be %s", JndiSession.class.getName()));
        }
    }

    static /* synthetic */ String lambda$loadAttribute$1(JndiSession jndiSession, String entryDN, LdapAttribute attribute) throws NamingException {
        return JndiLdapRepository.safeToString(jndiSession.context.getAttributes(entryDN, new String[]{attribute.getLdapAttributeName()}).get(attribute.getLdapAttributeName()));
    }

    static /* synthetic */ void lambda$storeAttribute$0(LdapAttribute attribute, String encodedValue, JndiSession jndiSession, String entryDN) throws NamingException {
        ModificationItem mi = new ModificationItem(2, new BasicAttribute(attribute.getLdapAttributeName(), encodedValue));
        jndiSession.context.modifyAttributes(entryDN, new ModificationItem[]{mi});
    }

    class JndiSession
    implements Session {
        final String uid;
        final LdapContext context;

        JndiSession(String uid, LdapContext context) {
            this.uid = uid;
            this.context = context;
        }
    }
}

