/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.ldap.profile.service.impl;

import de.deepamehta.ldap.Configuration;
import de.deepamehta.ldap.PluginLog;
import de.deepamehta.ldap.profile.feature.common.usecase.RunOnLdap;
import de.deepamehta.ldap.profile.feature.read.handler.ReadAttributesHandler;
import de.deepamehta.ldap.profile.feature.read.usecase.LoadAttribute;
import de.deepamehta.ldap.profile.feature.update.handler.UpdateAttributesHandler;
import de.deepamehta.ldap.profile.feature.update.usecase.StoreAttribute;
import de.deepamehta.ldap.profile.model.LdapAttribute;
import de.deepamehta.ldap.profile.repository.jndi.JndiLdapRepository;
import de.deepamehta.ldap.profile.service.ProfileService;
import de.deepamehta.ldap.profile.service.impl.ProfileServiceImpl$$Lambda$1;
import de.deepamehta.ldap.profile.service.impl.ProfileServiceImpl$$Lambda$2;
import de.deepamehta.ldap.profile.service.impl.ProfileServiceImpl$$Lambda$3;
import de.deepamehta.ldap.profile.service.impl.ProfileServiceImpl$$Lambda$4;
import de.deepamehta.ldap.profile.service.impl.ProfileServiceImpl$$Lambda$5;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProfileServiceImpl
implements ProfileService {
    private final ReadAttributesHandler readAttributesHandler;
    private final UpdateAttributesHandler updateAttributesHandler;

    public ProfileServiceImpl(Configuration configuration, PluginLog pluginLog) {
        JndiLdapRepository ldapRepository = new JndiLdapRepository(configuration, pluginLog);
        RunOnLdap runOnLdap = new RunOnLdap(ldapRepository);
        this.readAttributesHandler = new ReadAttributesHandler(runOnLdap, new LoadAttribute(ldapRepository));
        this.updateAttributesHandler = new UpdateAttributesHandler(runOnLdap, new StoreAttribute(ldapRepository));
    }

    private HashMap<LdapAttribute, String> setupMap(MapSetupRunner runner) {
        HashMap<LdapAttribute, String> map = new HashMap<LdapAttribute, String>();
        runner.invoke(map);
        return map;
    }

    @Override
    public boolean update(String userName, ProfileService.Attribute attribute, String value) {
        return this.updateAttributesHandler.invoke(userName, this.setupMap(ProfileServiceImpl$$Lambda$1.lambdaFactory$(attribute, value)));
    }

    @Override
    public boolean update(String userName, Map<ProfileService.Attribute, String> values) {
        return this.updateAttributesHandler.invoke(userName, this.setupMap(ProfileServiceImpl$$Lambda$2.lambdaFactory$(values)));
    }

    @Override
    public String read(String userName, ProfileService.Attribute attribute) {
        return this.readAttributesHandler.invoke(userName, Collections.singletonList(attribute.ldapAttribute)).get((Object)attribute.ldapAttribute);
    }

    @Override
    public Map<ProfileService.Attribute, String> read(String userName, List<ProfileService.Attribute> attributes) {
        return this.readAttributesHandler.invoke(userName, attributes.stream().map(ProfileServiceImpl$$Lambda$3.lambdaFactory$()).collect(Collectors.toList())).entrySet().stream().collect(Collectors.toMap(ProfileServiceImpl$$Lambda$4.lambdaFactory$(), ProfileServiceImpl$$Lambda$5.lambdaFactory$()));
    }

    static /* synthetic */ ProfileService.Attribute lambda$read$3(Map.Entry e) {
        return ProfileService.Attribute.findByLdapAttribute((LdapAttribute)((Object)e.getKey()));
    }

    static /* synthetic */ LdapAttribute lambda$read$2(ProfileService.Attribute a) {
        return a.ldapAttribute;
    }

    static /* synthetic */ void lambda$update$1(Map values, HashMap map) {
        for (Map.Entry entry : values.entrySet()) {
            map.put(((ProfileService.Attribute)((Object)entry.getKey())).ldapAttribute, entry.getValue());
        }
    }

    static /* synthetic */ void lambda$update$0(ProfileService.Attribute attribute, String value, HashMap map) {
        map.put(attribute.ldapAttribute, value);
    }

    private static interface MapSetupRunner {
        public void invoke(HashMap<LdapAttribute, String> var1);
    }
}

