/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.thymeleaf.provider;

import com.sun.jersey.api.view.Viewable;
import com.sun.jersey.spi.template.ViewProcessor;
import de.deepamehta.core.util.JavaUtils;
import de.deepamehta.thymeleaf.ThymeleafPlugin;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;

@Provider
public class ThymeleafViewProcessor
implements ViewProcessor<String> {
    @Context
    private UriInfo uriInfo;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public String resolve(String templateName) {
        return JavaUtils.getFilename((String)templateName);
    }

    public void writeTo(String templateName, Viewable viewable, OutputStream out) throws IOException {
        ThymeleafPlugin plugin = this.matchedPlugin();
        this.logger.info("Processing template \"" + templateName + "\" with TemplateEngine of " + (Object)((Object)plugin));
        this.processTemplate(plugin.getTemplateEngine(), templateName, (IContext)viewable.getModel(), out);
    }

    private ThymeleafPlugin matchedPlugin() {
        List resources = this.uriInfo.getMatchedResources();
        return (ThymeleafPlugin)((Object)resources.get(0));
    }

    private void processTemplate(TemplateEngine templateEngine, String templateName, IContext context, OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        templateEngine.process(templateName, context, (Writer)writer);
        ((Writer)writer).flush();
    }
}

