/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.plugins.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.core.CompDef;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.files.FilesService;
import systems.dmx.files.StoredFile;
import systems.dmx.files.UploadedFile;
import systems.dmx.plugins.csv.ImportStatus;

@Path(value="csv")
@Produces(value={"application/json"})
public class CsvPlugin
extends PluginActivator {
    private static Logger log = Logger.getLogger(CsvPlugin.class.getName());
    public static final char SEPARATOR = '|';
    public static final String SEPARATOR_MANY = ",";
    @Inject
    private FilesService files;

    @POST
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    @Transactional
    public Topic uploadCSV(UploadedFile file) {
        String operation = "Uploaded CSV " + file + " SUCCESSFULLY";
        try {
            log.info(operation);
            StoredFile storedFile = this.files.storeFile(file, "/");
            log.info("File stored. Fetching File Topic for HTTP Response.");
            return this.dmx.getTopic(storedFile.getFileTopicId());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @POST
    @Path(value="import/{fileId}")
    public ImportStatus importCsv(@PathParam(value="fileId") long fileId) {
        try {
            Topic configuredType = this.getConfiguredTopicType(fileId);
            TopicType topicType = this.dmx.getTopicType(configuredType.getUri());
            String typeUri = "";
            if (topicType == null) {
                return new ImportStatus(false, "please associate a Topic Type to the file topic for importing (via File Import association)", null);
            }
            typeUri = topicType.getUri();
            log.info("CSV Import configured for \"" + topicType.getSimpleValue() + "\" (" + typeUri + ")");
            List<String[]> lines = this.readCsvFile(fileId);
            if (lines.size() < 2) {
                return new ImportStatus(false, "please upload a valid CSV, see README", null);
            }
            List<Object> childTypeUris = Arrays.asList((Object[])lines.get(0));
            String uriPrefix = (String)childTypeUris.get(0);
            Map<String, Long> instancesOfUri = this.getTopicsByTypeWithURIPrefix(typeUri, uriPrefix);
            int created = 0;
            int deleted = 0;
            int updated = 0;
            for (int r = 1; r < lines.size(); ++r) {
                String[] row = lines.get(r);
                String topicUri = uriPrefix + "." + (String)row[0];
                TopicModel model = this.mf.newTopicModel(topicUri, typeUri);
                ChildTopicsModel value = this.mf.newChildTopicsModel();
                for (int c = 1; c < row.length; ++c) {
                    String childTypeUri = (String)childTypeUris.get(c);
                    Object childValue = row[c];
                    if (!this.isMany(topicType, childTypeUri)) {
                        value.set(childTypeUri, childValue);
                        continue;
                    }
                    String[] values = ((String)childValue).split(SEPARATOR_MANY);
                    for (int i = 0; i < values.length; ++i) {
                        value.add(childTypeUri, (Object)values[i]);
                    }
                }
                model.setChildTopics(value);
                Long topicId = instancesOfUri.get(topicUri);
                Topic object = null;
                DMXTransaction tx = this.dmx.beginTx();
                if (topicId == null) {
                    object = this.dmx.createTopic(model);
                    this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(object.getId(), "dmx.core.child"), (PlayerModel)this.mf.newTopicPlayerModel(fileId, "dmx.core.parent")));
                    ++created;
                    tx.success();
                } else {
                    model.setId(topicId.longValue());
                    instancesOfUri.remove(topicUri);
                    this.dmx.updateTopic(model);
                    this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(object.getId(), "dmx.core.child"), (PlayerModel)this.mf.newTopicPlayerModel(fileId, "dmx.core.parent")));
                    ++created;
                    ++updated;
                    tx.success();
                }
                tx.finish();
            }
            DMXTransaction tx = this.dmx.beginTx();
            for (String topicUri : instancesOfUri.keySet()) {
                Long topicId = instancesOfUri.get(topicUri);
                this.dmx.deleteTopic(topicId.longValue());
                ++deleted;
            }
            tx.success();
            tx.finish();
            ArrayList<String> status = new ArrayList<String>();
            status.add("created: " + created);
            status.add("updated: " + updated);
            status.add("deleted: " + deleted);
            return new ImportStatus(true, "SUCCESS", status);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isMany(TopicType topicType, String childTypeUri) {
        CompDef model = topicType.getCompDef(childTypeUri);
        return model.getChildCardinalityUri().equals("dmx.core.many");
    }

    private Map<String, Map<String, Long>> getPossibleAggrChilds(String typeUri, List<String> childTypeUris) {
        TopicType topicType = this.dmx.getTopicType(typeUri);
        HashMap<String, Map<String, Long>> aggrIdsByTypeUriAndValue = new HashMap<String, Map<String, Long>>();
        for (CompDef associationDefinition : topicType.getCompDefs()) {
            if (!associationDefinition.getTypeUri().equals("dmx.core.composition_def")) continue;
            String childTypeUri = associationDefinition.getChildTypeUri();
            log.info("childTypeUri: " + childTypeUri);
            if (!childTypeUris.contains(childTypeUri)) continue;
            log.info("childTypeUris contains: " + this.getTopicIdsByValue(childTypeUri));
            aggrIdsByTypeUriAndValue.put(childTypeUri, this.getTopicIdsByValue(childTypeUri));
        }
        return aggrIdsByTypeUriAndValue;
    }

    private Map<String, Long> getTopicIdsByValue(String childTypeUri) {
        HashMap<String, Long> idsByValue = new HashMap<String, Long>();
        for (Topic instance : this.dmx.getTopicsByType(childTypeUri)) {
            idsByValue.put(instance.getSimpleValue().toString(), instance.getId());
        }
        return idsByValue;
    }

    private Map<String, Long> getTopicsByTypeWithURIPrefix(String typeUri, String uriPrefix) {
        HashMap<String, Long> idsByUri = new HashMap<String, Long>();
        for (Topic topic : this.dmx.getTopicsByType(typeUri)) {
            String topicUri = topic.getUri();
            if (topicUri != null && !topicUri.isEmpty()) {
                log.fine("DEBUG: add topicURI \"" + topicUri + "\" to cache map");
                if (!topicUri.startsWith(uriPrefix)) continue;
                idsByUri.put(topicUri, topic.getId());
                continue;
            }
            log.fine("DEBUG: NOT add topicURI \"" + topicUri + "\" to cache map");
        }
        return idsByUri;
    }

    private List<String[]> readCsvFile(long fileId) throws IOException {
        String fileName = this.files.getFile(fileId).getAbsolutePath();
        log.info("read CSV " + fileName);
        CSVReader csvReader = new CSVReader(new FileReader(fileName), '|');
        List<String[]> lines = csvReader.readAll();
        csvReader.close();
        for (String[] row : lines) {
            for (int col = 0; col < row.length; ++col) {
                row[col] = row[col].trim();
            }
        }
        return lines;
    }

    private Topic getConfiguredTopicType(long fileId) {
        Topic csvFile = this.dmx.getTopic(fileId);
        return csvFile.getRelatedTopic("dmx.csv.file_import", null, null, null);
    }
}

