/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.deepl;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.deepl.DeepLService;
import systems.dmx.deepl.Translation;

@Path(value="/deepl")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DeepLPlugin
extends PluginActivator
implements DeepLService {
    private static final String DEEPL_URL = "https://api-free.deepl.com/v2/";
    private static final String DEEPL_AUTH_KEY = System.getProperty("dmx.deepl.auth_key");
    private static final String IMG_START = "<img src=\"";
    private static final String IMG_END = "\">";
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public List<Translation> translate(String text, String targetLang) {
        try {
            StringBuilder stripped = new StringBuilder();
            List<String> urls = this.stripImageURLs(text, stripped);
            String _stripped = stripped.toString();
            this.logger.info("Translating text (image URLs stripped): \"" + _stripped + "\", targetLang=\"" + targetLang + "\"");
            URLConnection con = new URL("https://api-free.deepl.com/v2/translate").openConnection();
            con.setRequestProperty("Authorization", "DeepL-Auth-Key " + DEEPL_AUTH_KEY);
            con.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(con.getOutputStream());
            out.write("text=" + JavaUtils.encodeURIComponent((String)_stripped) + "&target_lang=" + targetLang + "&tag_handling=html");
            out.flush();
            String responseData = JavaUtils.readText((InputStream)con.getInputStream());
            this.logger.info("responseData=" + responseData);
            JSONArray translations = new JSONObject(responseData).getJSONArray("translations");
            ArrayList<Translation> result = new ArrayList<Translation>();
            for (int i = 0; i < translations.length(); ++i) {
                JSONObject translation = translations.getJSONObject(i);
                result.add(new Translation(this.insertImageURLs(translation.getString("text"), urls), translation.getString("detected_source_language")));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("DeepL translation failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/usage")
    public InputStream usageStats() {
        try {
            URLConnection con = new URL("https://api-free.deepl.com/v2/usage").openConnection();
            con.setRequestProperty("Authorization", "DeepL-Auth-Key " + DEEPL_AUTH_KEY);
            con.connect();
            return con.getInputStream();
        }
        catch (Exception e) {
            throw new RuntimeException("Getting DeepL usage stats failed", e);
        }
    }

    private List<String> stripImageURLs(String text, StringBuilder builder) {
        int t1;
        ArrayList<String> urls = new ArrayList<String>();
        int ti = 0;
        while ((t1 = text.indexOf(IMG_START, ti)) != -1) {
            int t2 = text.indexOf(IMG_END, ti + IMG_START.length());
            String url = text.substring(t1 + IMG_START.length(), t2);
            urls.add(url);
            builder.append(text.substring(ti, t1 + IMG_START.length()));
            builder.append(IMG_END);
            ti = t2 + IMG_END.length();
        }
        builder.append(text.substring(ti));
        return urls;
    }

    private String insertImageURLs(String text, List<String> urls) {
        int t1;
        StringBuilder inserted = new StringBuilder();
        int ti = 0;
        int count = 0;
        while ((t1 = text.indexOf(IMG_START, ti)) != -1) {
            inserted.append(text.substring(ti, t1 + IMG_START.length()));
            inserted.append(urls.get(count++));
            inserted.append(IMG_END);
            ti = t1 + IMG_START.length() + IMG_END.length();
        }
        inserted.append(text.substring(ti));
        return inserted.toString();
    }
}

