/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.dita;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.dita.dost.ProcessorFactory;
import org.dita.dost.util.Configuration;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.CoreService;
import systems.dmx.dita.DITAExporter;
import systems.dmx.dita.TopicmapNavigation;
import systems.dmx.topicmaps.TopicmapsService;

class DITAProcess {
    private static final File DITA_DIR = new File(System.getProperty("dmx.dita.install_dir", ""));
    private static final File OUTPUT_DIR = new File(System.getProperty("dmx.dita.output_dir", ""));
    private static final File TEMP_DIR = new File(System.getProperty("dmx.dita.temp_dir", ""));
    private static final DITAExporter exporter = new DITAExporter(TEMP_DIR);
    private static final ProcessorFactory pf = ProcessorFactory.newInstance((File)DITA_DIR);
    private long processorId;
    private long topicmapId;
    private TopicmapNavigation tmNav;
    private CoreService dmx;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    DITAProcess(long processorId, long topicmapId, TopicmapsService tmService, CoreService dmx) {
        this.processorId = processorId;
        this.topicmapId = topicmapId;
        this.tmNav = new TopicmapNavigation(topicmapId, tmService, dmx);
        this.dmx = dmx;
    }

    void run() {
        List<Topic> sequence = this.findTopicSequence(this.processorId);
        this.logger.info("Topics in sequence: " + sequence.size());
        exporter.export(this.dmx.getTopic(this.topicmapId), sequence);
        this.runProcessor();
    }

    static List<String> getTranstypes() {
        return Configuration.transtypes;
    }

    private void runProcessor() {
        ClassLoader currentClassLoader = null;
        try {
            currentClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader bundleClassloader = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(bundleClassloader);
            this.logDebugInfo(currentClassLoader, bundleClassloader);
            pf.newProcessor(this.getOutputFormat()).setInput(new File(TEMP_DIR, this.topicmapId + ".xml")).setOutputDir(OUTPUT_DIR).run();
            this.logger.info("DITA-OT processing successful");
        }
        catch (Exception e) {
            throw new RuntimeException("DITA-OT processing failed", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private List<Topic> findTopicSequence(long processorId) {
        ArrayList<Topic> sequence = new ArrayList<Topic>();
        Topic topic = this.findStartTopic(processorId);
        while (topic != null) {
            sequence.add(topic);
            topic = this.findNextTopic(topic.getId());
        }
        return sequence;
    }

    private Topic findStartTopic(long processorId) {
        try {
            RelatedTopic topic = this.tmNav.getRelatedTopic(processorId, "dmx.core.association", "dmx.core.default", "dmx.core.default", null);
            if (topic == null) {
                throw new RuntimeException("No start topic defined");
            }
            return topic;
        }
        catch (Exception e) {
            throw new RuntimeException("Finding start topic failed", e);
        }
    }

    private Topic findNextTopic(long topicId) {
        try {
            return this.tmNav.getRelatedTopic(topicId, "dmx.core.sequence", "dmx.core.predecessor", "dmx.core.successor", null);
        }
        catch (Exception e) {
            throw new RuntimeException("Finding next topic in sequence failed", e);
        }
    }

    private String getOutputFormat() {
        String outputFormat = this.dmx.getTopic(this.processorId).getChildTopics().getStringOrNull("dmx.dita.output_format");
        if (outputFormat == null) {
            throw new RuntimeException("Output format not set");
        }
        return outputFormat;
    }

    private void logDebugInfo(ClassLoader currentClassLoader, ClassLoader bundleClassloader) {
        this.logger.info("org.osgi.framework.bootdelegation=" + System.getProperty("org.osgi.framework.bootdelegation") + "\n      org.osgi.framework.system.packages.extra=" + System.getProperty("org.osgi.framework.system.packages.extra") + "\n      Current ClassLoader=" + currentClassLoader + ", parent=" + currentClassLoader.getParent() + "\n      Bundle ClassLoader=" + bundleClassloader + ", parent=" + bundleClassloader.getParent() + "\n      Available transtypes=" + Configuration.transtypes);
    }

    static {
        pf.setBaseTempDir(TEMP_DIR);
    }
}

