/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.geomaps;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.util.DMXUtils;

public class Geomap
implements Iterable<TopicModel>,
JSONEnabled {
    private TopicModel geomapTopic;
    private ViewProps viewProps;
    private Map<Long, TopicModel> geoCoords;
    private Map<Long, List<TopicModel>> domainTopics;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    Geomap(TopicModel geomapTopic, ViewProps viewProps, Map<Long, TopicModel> geoCoords, Map<Long, List<TopicModel>> domainTopics) {
        this.geomapTopic = geomapTopic;
        this.viewProps = viewProps;
        this.geoCoords = geoCoords;
        this.domainTopics = domainTopics;
    }

    public long getId() {
        return this.geomapTopic.getId();
    }

    public boolean containsTopic(long geoCoordId) {
        return this.geoCoords.get(geoCoordId) != null;
    }

    public JSONObject toJSON() {
        try {
            return new JSONObject().put("topic", (Object)this.geomapTopic.toJSON()).put("viewProps", (Object)this.viewProps.toJSON()).put("geoMarkers", this.geoMarkersJSON(this.geoCoords, this.domainTopics));
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    public Iterator<TopicModel> iterator() {
        return this.geoCoords.values().iterator();
    }

    public String toString() {
        return "geomap " + this.getId();
    }

    private Object geoMarkersJSON(Map<Long, TopicModel> geoCoords, Map<Long, List<TopicModel>> domainTopics) {
        JSONArray geoMarkers = new JSONArray();
        for (TopicModel item : geoCoords.values()) {
            JSONObject json = new JSONObject();
            List<TopicModel> domain = domainTopics.get(item.getId());
            try {
                json.put("geoCoordTopic", (Object)item.toJSON());
                json.put("domainTopics", (Object)DMXUtils.toJSONArray(domain));
                geoMarkers.put((Object)json);
            }
            catch (Exception e) {
                throw new RuntimeException("Serialization failed", e);
            }
        }
        return geoMarkers;
    }
}

