/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.images;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.imgscalr.Scalr;
import systems.dmx.core.Assoc;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.files.DirectoryListing;
import systems.dmx.files.FilesService;
import systems.dmx.files.ItemKind;
import systems.dmx.files.ResourceInfo;
import systems.dmx.files.StoredFile;
import systems.dmx.files.UploadedFile;
import systems.dmx.images.Image;
import systems.dmx.images.ImageService;

@Path(value="/images")
public class ImagePlugin
extends PluginActivator
implements ImageService {
    private static Logger log = Logger.getLogger(ImagePlugin.class.getName());
    public static final String FILEREPO_BASE_URI_NAME = "filerepo";
    public static final String FILEREPO_IMAGES_SUBFOLDER = "images";
    public static final String DM4_HOST_URL = System.getProperty("dmx.host.url");
    public static final String RESIZED_IMAGE = "dmx.images.resized_image";
    @Inject
    private FilesService files;

    @POST
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Transactional
    public Topic upload(UploadedFile image) {
        String imagesFolderPath = this.getImagesDirectoryInFileRepo();
        log.info("Upload image " + image.getName() + " to filerepo folder=" + imagesFolderPath);
        try {
            StoredFile file = this.files.storeFile(image, imagesFolderPath);
            String path = imagesFolderPath + File.separator + file.getFileName();
            return this.files.getFileTopic(path);
        }
        catch (Exception e) {
            log.severe(e.getMessage() + ", caused by " + e.getCause().getMessage());
            return null;
        }
    }

    @Override
    @POST
    @Path(value="/resize/{topicId}/{maxSize}/{mode}")
    @Produces(value={"application/json"})
    @Transactional
    public RelatedTopicModel resizeImageFileTopic(@PathParam(value="topicId") long fileTopicId, @PathParam(value="maxSize") int maxSize, @PathParam(value="mode") String mode) {
        log.info("File Topic to Resize (ID: " + fileTopicId + ") Max Size: " + maxSize + "px");
        try {
            File fileTopicFile = this.files.getFile(fileTopicId);
            String fileTopicFileName = fileTopicFile.getName();
            Topic fileTopic = (Topic)this.dmx.getTopic(fileTopicId).loadChildTopics();
            String fileTopicRepositoryPath = fileTopic.getChildTopics().getString("dmx.files.path");
            String fileMediaType = fileTopic.getChildTopics().getString("dmx.files.media_type");
            if (fileMediaType.contains("jpeg") || fileMediaType.contains("jpg") || fileMediaType.contains("png")) {
                log.info("Image File Topic Path requested to be RESIZED: " + fileTopicRepositoryPath);
                BufferedImage srcImage = ImageIO.read(fileTopicFile);
                log.info("Image File Buffered " + srcImage);
                BufferedImage scaledImage = null;
                scaledImage = mode.equals("width") ? Scalr.resize((BufferedImage)srcImage, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)maxSize, (BufferedImageOp[])new BufferedImageOp[0]) : (mode.equals("height") ? Scalr.resize((BufferedImage)srcImage, (Scalr.Mode)Scalr.Mode.FIT_TO_HEIGHT, (int)maxSize, (BufferedImageOp[])new BufferedImageOp[0]) : Scalr.resize((BufferedImage)srcImage, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)maxSize, (BufferedImageOp[])new BufferedImageOp[0]));
                String imageFileEnding = fileTopicFileName.substring(fileTopicFileName.indexOf(".") + 1);
                String imageFileTopicParentRepositoryPath = this.getParentFolderRepositoryPath(fileTopicRepositoryPath);
                String newFileName = this.calculateResizedFilename(fileTopicFileName, maxSize + "");
                File resizedImageFile = new File(fileTopicFile.getParent() + File.separator + newFileName);
                if (resizedImageFile.createNewFile()) {
                    ImageIO.write((RenderedImage)scaledImage, imageFileEnding, resizedImageFile);
                    log.info("Resized Image File \"" + resizedImageFile.getAbsolutePath() + "\" CREATED");
                } else {
                    if (imageFileEnding.equals("jpg")) {
                        imageFileEnding = "jpeg";
                    }
                    ImageIO.write((RenderedImage)scaledImage, imageFileEnding, resizedImageFile);
                    log.warning("Image File already exists \"" + resizedImageFile.getPath() + "\" - REWRITE");
                }
                Topic resizedImageFileTopic = this.files.getFileTopic(imageFileTopicParentRepositoryPath + File.separator + newFileName);
                return this.createResizedImageAssociation(fileTopic, resizedImageFileTopic);
            }
            throw new WebApplicationException((Throwable)new RuntimeException("Sorry! At the moment we can only resize JPGs or PNGs and not file topics with MediaType: " + fileMediaType), Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private String calculateResizedFilename(String originalFilename, String sizeParameter) {
        String imageFileEnding = originalFilename.substring(originalFilename.indexOf(".") + 1);
        String imageFileBeginning = originalFilename.substring(originalFilename.lastIndexOf("/") + 1, originalFilename.indexOf("."));
        return imageFileBeginning + "-" + sizeParameter + "px." + imageFileEnding;
    }

    private String getParentFolderRepositoryPath(String fileTopicRepositoryPath) {
        String pathSeperator = "/";
        if (System.getProperty("os.name").contains("Win")) {
            log.info("Lookup parent folder on " + System.getProperty("os.name") + " using \\");
            pathSeperator = "\\";
        }
        return fileTopicRepositoryPath.substring(0, fileTopicRepositoryPath.lastIndexOf(pathSeperator));
    }

    private RelatedTopicModel createResizedImageAssociation(Topic original, Topic resized) {
        Assoc exists = original.getAssoc(RESIZED_IMAGE, null, null, resized.getId());
        if (exists == null) {
            exists = this.dmx.createAssoc(this.mf.newAssocModel(RESIZED_IMAGE, (PlayerModel)this.mf.newTopicPlayerModel(original.getId(), "dmx.core.parent"), (PlayerModel)this.mf.newTopicPlayerModel(resized.getId(), "dmx.core.child")));
        } else {
            log.info("Resize Image Notice: Rewrote the image files contents but did not create a new file topic");
        }
        return this.mf.newRelatedTopicModel(resized.getModel(), exists.getModel());
    }

    @GET
    @Path(value="/browse")
    @Produces(value={"application/json"})
    public List<Image> browse() {
        String imagesFolderPath = this.getImagesDirectoryInFileRepo();
        try {
            ArrayList<Image> images = new ArrayList<Image>();
            DirectoryListing imagesDirectory = this.files.getDirectoryListing(imagesFolderPath);
            for (DirectoryListing.FileItem image : imagesDirectory.getFileItems()) {
                log.info("  Include image in repository with name \"" + image.getName() + "\"");
                String src = this.getRepoUri(image.getPath());
                images.add(new Image(src, image.getMediaType(), image.getSize(), image.getName()));
            }
            return images;
        }
        catch (WebApplicationException e) {
            log.info("Calling for a DirectoryListing has THROWN an Error");
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getImagesDirectoryInFileRepo() {
        String folderPath = FILEREPO_IMAGES_SUBFOLDER;
        if (!this.files.pathPrefix().equals("/")) {
            folderPath = this.files.pathPrefix() + File.separator + FILEREPO_IMAGES_SUBFOLDER;
        }
        try {
            if (this.files.fileExists(folderPath)) {
                ResourceInfo resourceInfo = this.files.getResourceInfo(this.files.pathPrefix() + File.separator + FILEREPO_IMAGES_SUBFOLDER);
                if (resourceInfo.getItemKind() != ItemKind.DIRECTORY) {
                    String message = "ImagePlugin: \"images\" storage directory in repo path " + folderPath + " can not be used";
                    throw new IllegalStateException(message);
                }
            } else {
                log.info("Creating the \"images\" subfolder on the fly for new filerepo in " + folderPath + "!");
                this.files.createFolder(FILEREPO_IMAGES_SUBFOLDER, this.files.pathPrefix());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return folderPath;
    }

    private String getRepoUri(String path) {
        return DM4_HOST_URL + FILEREPO_BASE_URI_NAME + "/" + JavaUtils.encodeURIComponent((String)path);
    }
}

