/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.ldap;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accesscontrol.AuthorizationMethod;
import systems.dmx.core.Assoc;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.event.PostCreateAssoc;
import systems.dmx.core.service.event.PostDeleteAssoc;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.ldap.Configuration;
import systems.dmx.ldap.LDAP;
import systems.dmx.ldap.LDAP$;
import systems.dmx.ldap.LDAPPlugin$$Lambda$1;
import systems.dmx.ldap.LDAPPlugin$$Lambda$3;
import systems.dmx.ldap.PluginLog;
import systems.dmx.ldap.PluginLog$;
import systems.dmx.ldap.service.LDAPPluginService;
import systems.dmx.workspaces.WorkspacesService;

public class LDAPPlugin
extends PluginActivator
implements AuthorizationMethod,
LDAPPluginService,
PostCreateAssoc,
PostDeleteAssoc {
    public static final String WORKSPACE_TYPE = "dmx.workspaces.workspace";
    public static final String GROUP_TYPE = "systems.dmx.ldap.group";
    public static final String COMPOSITION_ASSOC_TYPE = "dmx.core.composition";
    public static final String MEMBERSHIP_ASSOC_TYPE = "dmx.accesscontrol.membership";
    public static final String USERNAME_TOPIC_TYPE = "dmx.accesscontrol.username";
    private static Logger logger = Logger.getLogger(LDAPPlugin.class.getName());
    @Inject
    private AccessControlService acs;
    @Inject
    private WorkspacesService wss;
    private Configuration configuration;
    private PluginLog pluginLog;
    private LDAP ldap;

    public void serviceArrived(Object service) {
        if (service instanceof AccessControlService) {
            ((AccessControlService)service).registerAuthorizationMethod("LDAP", (AuthorizationMethod)this);
        }
    }

    public void serviceGone(Object service) {
        if (service instanceof AccessControlService) {
            ((AccessControlService)service).unregisterAuthorizationMethod("LDAP");
        }
    }

    public void init() {
        try {
            this.configuration = Configuration.createFromProperties();
            this.pluginLog = PluginLog$.newInstance(this.configuration.loggingMode);
        }
        catch (Exception e) {
            this.configuration = Configuration.createFallback();
            this.pluginLog = PluginLog$.newInstance(this.configuration.loggingMode);
            this.pluginLog.configurationError("Error parsing configuration", e);
            this.pluginLog.configurationHint("Configuration could not be parsed. Providing an emergency fallback configuration. LDAP logins will not work!", new Object[0]);
        }
        this.pluginLog.configurationHint("Plugin configuration:\n%s", this.configuration.summary());
        if (!this.configuration.check(this.pluginLog)) {
            this.pluginLog.configurationError("LDAP Plugin configuration is not correct. Please fix the issues mentioned in the log.", new Object[0]);
            this.ldap = LDAP$.newDummyInstance(this.pluginLog);
        } else {
            this.configuration.compile();
            this.ldap = LDAP$.newInstance(this.configuration, this.pluginLog);
        }
    }

    public Topic checkCredentials(Credentials cred) {
        if (this.ldap.checkCredentials(cred.username, cred.plaintextPassword)) {
            Topic username = this.lookupOrCreateUsernameTopic(cred.username);
            if (username != null) {
                this.pluginLog.actionHint("LDAP log-in successful for user %s", cred.username);
                return username;
            }
            this.pluginLog.actionError("Credentials in LDAP are OK but unable find or create username topic", null);
            return null;
        }
        this.pluginLog.actionError(String.format("Credential check for user %s failed.", cred.username), null);
        return null;
    }

    @Override
    public Topic createUser(Credentials cred) {
        if (!this.configuration.userCreationEnabled) {
            logger.warning("User creation is disabled in plugin configuration!");
            return null;
        }
        final AtomicReference usernameTopicRef = new AtomicReference();
        this.ldap.createUser(cred.username, cred.plaintextPassword, new LDAP.CompletableAction(){

            @Override
            public boolean run(String username) {
                Topic usernameTopic = null;
                try {
                    usernameTopic = LDAPPlugin.this.lookupOrCreateUsernameTopic(username);
                    boolean bl = usernameTopic != null;
                    return bl;
                }
                catch (Exception e) {
                    LDAPPlugin.this.pluginLog.actionError(String.format("Creating username %s failed but LDAP entry was already created. Rolling back.", username), e);
                    throw new RuntimeException("Creating username failed", e);
                }
                finally {
                    usernameTopicRef.set(usernameTopic);
                }
            }
        });
        return (Topic)usernameTopicRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topic lookupOrCreateUsernameTopic(String username) {
        Topic usernameTopic = this.acs.getUsernameTopic(username);
        if (usernameTopic != null) {
            return usernameTopic;
        }
        DMXTransaction tx = this.dmx.beginTx();
        try {
            usernameTopic = this.acs.createUsername(username);
            tx.success();
            Topic topic = usernameTopic;
            return topic;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public Topic changePassword(Credentials credentials) {
        if (!this.configuration.userCreationEnabled) {
            this.pluginLog.actionWarning("Cannot change password because user creation is disabled in plugin configuration!", new Object[0]);
            return null;
        }
        Topic usernameTopic = this.acs.getUsernameTopic(credentials.username);
        if (usernameTopic != null && this.ldap.changePassword(credentials.username, credentials.plaintextPassword)) {
            this.pluginLog.actionHint("Succesfully changed password for %s", credentials.username);
            return usernameTopic;
        }
        return null;
    }

    @Override
    public void deleteUser(String userName) {
        Topic userTopic = this.acs.getUsernameTopic(userName);
        userTopic.delete();
        if (!this.ldap.deleteUser(userName)) {
            throw new IllegalStateException("User deleted from DMX but not from LDAP.");
        }
    }

    private List<String> getMembers(Topic workspaceTopic, String excluded) {
        return workspaceTopic.getRelatedTopics(MEMBERSHIP_ASSOC_TYPE, null, null, USERNAME_TOPIC_TYPE).stream().map(LDAPPlugin$$Lambda$1.lambdaFactory$()).filter(LDAPPlugin$$Lambda$3.lambdaFactory$(excluded)).collect(Collectors.toList());
    }

    private boolean isWorkspaceGroupComposition(AssocModel assoc) {
        return this.isType(assoc, COMPOSITION_ASSOC_TYPE) && this.isType(assoc.getPlayer1(), WORKSPACE_TYPE) && this.isType(assoc.getPlayer2(), GROUP_TYPE);
    }

    private boolean isUsernameWorkspaceMembership(AssocModel assoc) {
        return this.isType(assoc, MEMBERSHIP_ASSOC_TYPE) && this.isPlayerType(assoc, USERNAME_TOPIC_TYPE) && this.isPlayerType(assoc, WORKSPACE_TYPE);
    }

    public void postCreateAssoc(Assoc assoc) {
        if (this.isWorkspaceGroupComposition(assoc.getModel())) {
            String userName = this.acs.getWorkspaceOwner(assoc.getPlayer1().getId());
            String group = this.dmx.getTopic(assoc.getPlayer2().getId()).getSimpleValue().toString();
            Topic workspace = this.dmx.getTopic(assoc.getPlayer1().getId());
            this.ldap.createGroup(group, userName, this.getMembers(workspace, userName));
        } else if (this.isUsernameWorkspaceMembership(assoc.getModel())) {
            String group = this.getPlayerTopicByType(assoc.getModel(), WORKSPACE_TYPE).getChildTopics().getString(GROUP_TYPE, null);
            String userName = this.getPlayerTopicByType(assoc.getModel(), USERNAME_TOPIC_TYPE).getSimpleValue().toString();
            String workspaceOwner = this.acs.getWorkspaceOwner(assoc.getPlayer2().getId());
            if (group != null && !userName.equals(workspaceOwner)) {
                this.ldap.addMember(group, userName);
            }
        }
    }

    public void postDeleteAssoc(AssocModel assoc) {
        if (this.isWorkspaceGroupComposition(assoc)) {
            String group = this.dmx.getTopic(assoc.getPlayer2().getId()).getSimpleValue().toString();
            this.ldap.deleteGroup(group);
        } else if (this.isUsernameWorkspaceMembership(assoc)) {
            String group = this.getPlayerTopicByType(assoc, WORKSPACE_TYPE).getChildTopics().getString(GROUP_TYPE, null);
            String userName = this.getPlayerTopicByType(assoc, USERNAME_TOPIC_TYPE).getSimpleValue().toString();
            String workspaceOwner = this.acs.getWorkspaceOwner(assoc.getPlayer2().getId());
            if (group != null && !userName.equals(workspaceOwner)) {
                this.ldap.removeMember(group, userName);
            }
        }
    }

    private boolean isPlayerType(AssocModel assoc, String typeUri) {
        return assoc.getPlayer1().getTypeUri().equals(typeUri) || assoc.getPlayer2().getTypeUri().equals(typeUri);
    }

    private Topic getPlayerTopicByType(AssocModel assoc, String typeUri) {
        if (assoc.getPlayer1().getTypeUri().equals(typeUri)) {
            return this.dmx.getTopic(assoc.getPlayer1().getId());
        }
        if (assoc.getPlayer2().getTypeUri().equals(typeUri)) {
            return this.dmx.getTopic(assoc.getPlayer2().getId());
        }
        throw new IllegalStateException("Requested topic type is not a player of the association!");
    }

    private boolean isType(PlayerModel playerModel, String typeUri) {
        return playerModel.getTypeUri().equals(typeUri);
    }

    private boolean isType(AssocModel assoc, String typeUri) {
        return assoc.getTypeUri().equals(typeUri);
    }

    static /* synthetic */ boolean lambda$getMembers$1(String excluded, String name) {
        return !name.equals(excluded);
    }

    static /* synthetic */ String lambda$getMembers$0(RelatedTopic relatedTopic) {
        return relatedTopic.getSimpleValue().toString();
    }
}

