/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.thymeleaf;

import com.sun.jersey.api.view.Viewable;
import com.sun.jersey.spi.container.ContainerRequest;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import org.osgi.framework.Bundle;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.context.AbstractContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolver;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.event.ServiceRequestFilter;

@Path(value="/thymeleaf")
public class ThymeleafPlugin
extends PluginActivator
implements ServiceRequestFilter {
    private static String ATTR_CONTEXT = "systems.dmx.thymeleaf.Context";
    private static String TEMPLATES_FOLDER = "/views/";
    private static String TEMPLATES_ENDING = ".html";
    private TemplateEngine templateEngine;
    Set<Bundle> additionalTemplateResourceBundles = new HashSet<Bundle>();
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    @Context
    private ServletContext servletContext;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void serviceRequestFilter(ContainerRequest containerRequest) {
        this.request.setAttribute(ATTR_CONTEXT, (Object)new WebContext(this.request, this.response, this.servletContext));
    }

    public TemplateEngine getTemplateEngine() {
        if (this.templateEngine == null) {
            throw new RuntimeException("The template engine for " + (Object)((Object)this) + " is not initialized. Don't forget calling initTemplateEngine() from your plugin's init() hook.");
        }
        return this.templateEngine;
    }

    protected void addTemplateResourceBundle(Bundle templateBundleResource) {
        this.additionalTemplateResourceBundles.add(templateBundleResource);
    }

    protected void removeTemplateResourceBundle(Bundle templateBundleResource) {
        this.additionalTemplateResourceBundles.remove(templateBundleResource);
    }

    protected void initTemplateEngine() {
        this.templateEngine = new TemplateEngine();
        int order = 1;
        if (this.additionalTemplateResourceBundles.size() > 0) {
            this.logger.info("Initializing Thymeleaf TemplateEngine with additional template resolver bundles...");
            for (Bundle otherTemplateResourceBundle : this.additionalTemplateResourceBundles) {
                TemplateResolver otherTemplateResolver = this.createBundleResourcesResolver(otherTemplateResourceBundle, order);
                this.templateEngine.addTemplateResolver((ITemplateResolver)otherTemplateResolver);
                this.logger.info("Added template resolver bundle \"" + otherTemplateResourceBundle.getSymbolicName() + "\"");
                ++order;
            }
        } else {
            this.logger.info("Initializing Thymeleaf TemplateEngine for \"" + this.bundle.getSymbolicName() + "\" without any additional template resolver bundles...");
        }
        this.templateEngine.addTemplateResolver((ITemplateResolver)this.createBundleResourcesResolver(this.bundle, order));
    }

    protected void viewData(String name, Object value) {
        this.context().setVariable(name, value);
    }

    protected Viewable view(String templateName) {
        return new Viewable(templateName, (Object)this.context());
    }

    private TemplateResolver createBundleResourcesResolver(Bundle bundle, int order) {
        TemplateResolver tr = new TemplateResolver();
        tr.setResourceResolver((IResourceResolver)new BundleResourcesResolver(bundle));
        tr.setOrder(Integer.valueOf(order));
        tr.setPrefix(TEMPLATES_FOLDER);
        tr.setSuffix(TEMPLATES_ENDING);
        return tr;
    }

    protected AbstractContext context() {
        return (AbstractContext)this.request.getAttribute(ATTR_CONTEXT);
    }

    private class BundleResourcesResolver
    implements IResourceResolver {
        private Bundle bundle;

        private BundleResourcesResolver(Bundle bundle) {
            this.bundle = bundle;
        }

        public String getName() {
            return this.bundle.getSymbolicName() + ".BundleResourcesResolver";
        }

        public InputStream getResourceAsStream(TemplateProcessingParameters params, String resourceName) {
            try {
                return this.bundle.getResource(resourceName).openStream();
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

